/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import me.helloworld.utils.Chars;
import me.helloworld.utils.collection.ArrayUtils;
import me.helloworld.utils.reflect.Members;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checker {
    public static boolean isSameLength(Object[] array1, Object[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(CharSequence s) {
        int strLen;
        if (s == null || (strLen = s.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(String[] strs) {
        if (Checker.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!Checker.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqual(Object lhs, Object rhs) {
        return lhs == rhs || lhs != null && lhs.equals(rhs);
    }

    public static boolean isEquals(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        int len2 = b2.length;
        int len1 = b1.length;
        if (len2 != len1) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyNull(Object ... args) {
        for (Object o : args) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNotNull(Object ... args) {
        return !Checker.isAnyNull(args);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        if (!Checker.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (Checker.isAssignable(classArray[i], toClassArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = Members.primitiveToWrapper(cls)) == null) {
            return false;
        }
        if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = Members.wrapperToPrimitive(cls)) == null) {
            return false;
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (Checker.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                return !hasDecPoint && !hasExp && foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            return (chars[i] == 'l' || chars[i] == 'L') && foundDigit && !hasExp && !hasDecPoint;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isAlpha(CharSequence cs, char ... exclusions) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Chars.isAlpha(cs.charAt(i))) continue;
            if (Checker.isEmpty(exclusions)) {
                return false;
            }
            if (ArrayUtils.indexOf(exclusions, cs.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs, char ... exclusions) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Chars.isAlphaNum(cs.charAt(i))) continue;
            if (Checker.isEmpty(exclusions)) {
                return false;
            }
            if (ArrayUtils.indexOf(exclusions, cs.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(CharSequence cs, char ... exclusions) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Chars.isDigit(cs.charAt(i))) continue;
            if (Checker.isEmpty(exclusions)) {
                return false;
            }
            if (ArrayUtils.indexOf(exclusions, cs.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Chars.isAsciiPrintable(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidURIScheme(String s) {
        try {
            if (!Chars.isAlpha(s.charAt(0))) {
                return false;
            }
            for (int i = 1; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Chars.isAlphaNum(c) || c == '+' || c == '-' || c == '.') continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSQLString(Object o) {
        return o instanceof CharSequence || o instanceof Timestamp;
    }
}

