/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import me.helloworld.utils.Chars;
import me.helloworld.utils.Checker;
import me.helloworld.utils.Objects;

public class Converter {
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static long toLong(Object o, long defaultValue) {
        Long ret = Converter.toLong(o);
        return ret == null ? defaultValue : ret;
    }

    public static Long toLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof java.util.Date) {
            return ((java.util.Date)o).getTime();
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTimeInMillis();
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static long toLong(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Chars.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Chars.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static long toLong(char[] b, int off, int len) throws NumberFormatException {
        char c;
        if (b == null || len <= 0 || !Chars.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Chars.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static int toInt(Object o, int defaultValue) {
        Integer ret = Converter.toInt(o);
        return ret == null ? defaultValue : ret;
    }

    public static Integer toInt(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int toInt(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Chars.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Chars.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static int toInt(char[] b, int off, int len) throws NumberFormatException {
        char c;
        if (b == null || len <= 0 || !Chars.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Chars.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static float toFloat(Object o, float defaultValue) {
        Float ret = Converter.toFloat(o);
        return ret == null ? defaultValue : ret.floatValue();
    }

    public static Float toFloat(Object o) {
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Double toDouble(Object o, double defaultValue) {
        Double ret = Converter.toDouble(o);
        return ret == null ? defaultValue : ret;
    }

    public static Double toDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean toBoolean(Object o, boolean def) {
        Boolean ret = Converter.toBoolean(o);
        return ret == null ? def : ret;
    }

    public static Boolean toBoolean(Object o) {
        String str = Objects.toString(o);
        if (Checker.isEmpty(str)) {
            return null;
        }
        if (str == "true") {
            return true;
        }
        switch (str.length()) {
            case 1: {
                char ch0 = str.charAt(0);
                if (ch0 == 'y' || ch0 == 'Y' || ch0 == 't' || ch0 == 'T' || ch0 == '1') {
                    return true;
                }
                if (ch0 != 'n' && ch0 != 'N' && ch0 != 'f' && ch0 != 'F') break;
                return false;
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (!(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N')) {
                    return true;
                }
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return false;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (!(ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S')) {
                    return true;
                }
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return false;
            }
            case 4: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return true;
            }
            case 5: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                char ch4 = str.charAt(4);
                if (ch0 != 'f' && ch0 != 'F' || ch1 != 'a' && ch1 != 'A' || ch2 != 'l' && ch2 != 'L' || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && ch4 != 'E') break;
                return false;
            }
        }
        return null;
    }

    public static String toString(byte[] bytes, String encoding) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, encoding);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static byte[] toBytes(String string, String encoding) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(encoding);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static byte[] toBytes(short s, boolean asc) {
        byte[] buf = new byte[2];
        if (asc) {
            for (int i = buf.length - 1; i >= 0; --i) {
                buf[i] = (byte)(s & 0xFF);
                s = (short)(s >> 8);
            }
        } else {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(s & 0xFF);
                s = (short)(s >> 8);
            }
        }
        return buf;
    }

    public static byte[] toBytes(int s, boolean asc) {
        byte[] buf = new byte[4];
        if (asc) {
            for (int i = buf.length - 1; i >= 0; --i) {
                buf[i] = (byte)(s & 0xFF);
                s >>= 8;
            }
        } else {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(s & 0xFF);
                s >>= 8;
            }
        }
        return buf;
    }

    public static byte[] toBytes(long s, boolean asc) {
        byte[] buf = new byte[8];
        if (asc) {
            for (int i = buf.length - 1; i >= 0; --i) {
                buf[i] = (byte)(s & 0xFFL);
                s >>= 8;
            }
        } else {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(s & 0xFFL);
                s >>= 8;
            }
        }
        return buf;
    }

    public static byte toByte(Object o, byte def) {
        Byte ret = Converter.toByte(o);
        return ret == null ? def : ret;
    }

    public static Byte toByte(Object o) {
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return Byte.parseByte(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static short toShort(Object o, short def) {
        Short ret = Converter.toShort(o);
        return ret == null ? def : ret;
    }

    public static Short toShort(Object o) {
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return Short.parseShort(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static char toChar(Object o, char def) {
        Character ret = Converter.toChar(o);
        return ret == null ? def : ret.charValue();
    }

    public static Character toChar(Object o) {
        if (o instanceof Character) {
            return (Character)o;
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s) || s.length() != 1) {
            return null;
        }
        return Character.valueOf(s.charAt(0));
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return new BigDecimal(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static BigInteger toBigInteger(Object o) {
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return BigInteger.valueOf(((Number)o).longValue());
        }
        String s = Objects.toString(o);
        if (Checker.isEmpty(s)) {
            return null;
        }
        try {
            return new BigInteger(s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static java.util.Date toDate(Object value, java.util.Date def) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Number) {
            try {
                return new java.util.Date(((Number)value).longValue());
            }
            catch (Throwable t) {
                return def;
            }
        }
        String strVal = Objects.toString(value);
        if (Checker.isEmpty(strVal)) {
            return def;
        }
        if (strVal.indexOf(45) != -1) {
            String format = null;
            format = strVal.length() == DEFFAULT_DATE_FORMAT.length() ? DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss.SSS");
            try {
                return new SimpleDateFormat(format).parse(strVal);
            }
            catch (ParseException e) {
                return def;
            }
        }
        Long longVal = Converter.toLong(strVal);
        if (longVal == null) {
            return def;
        }
        try {
            return new java.util.Date(longVal);
        }
        catch (Throwable t) {
            return def;
        }
    }

    public static Date toSQLDate(Object value, Date def) {
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            try {
                return new Date(((Number)value).longValue());
            }
            catch (Throwable t) {
                return def;
            }
        }
        String strVal = Objects.toString(value);
        if (Checker.isEmpty(strVal)) {
            return def;
        }
        try {
            return Date.valueOf(strVal);
        }
        catch (Throwable t) {
            if (strVal.indexOf(45) != -1) {
                String format = null;
                format = strVal.length() == DEFFAULT_DATE_FORMAT.length() ? DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss.SSS");
                try {
                    return new Date(new SimpleDateFormat(format).parse(strVal).getTime());
                }
                catch (ParseException e) {
                    return def;
                }
            }
            Long longVal = Converter.toLong(strVal);
            if (longVal == null) {
                return def;
            }
            try {
                return new Date(longVal);
            }
            catch (Throwable t1) {
                return def;
            }
        }
    }

    public static Timestamp toTimestamp(Object value, Timestamp def) {
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            try {
                return new Timestamp(((Number)value).longValue());
            }
            catch (Throwable t) {
                return def;
            }
        }
        String strVal = Objects.toString(value);
        if (Checker.isEmpty(strVal)) {
            return def;
        }
        try {
            return Timestamp.valueOf(strVal);
        }
        catch (Throwable t) {
            if (strVal.indexOf(45) != -1) {
                String format = null;
                format = strVal.length() == DEFFAULT_DATE_FORMAT.length() ? DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss.SSS");
                try {
                    return new Timestamp(new SimpleDateFormat(format).parse(strVal).getTime());
                }
                catch (ParseException e) {
                    return def;
                }
            }
            Long longVal = Converter.toLong(strVal);
            if (longVal == null) {
                return def;
            }
            try {
                return new Timestamp(longVal);
            }
            catch (Throwable t1) {
                return def;
            }
        }
    }
}

