/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.Exceptions;
import me.helloworld.utils.annotation.StringPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objects {
    public static final Null NULL = new Null();

    private Objects() {
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static String identityString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        return buffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object))).toString();
    }

    public static String toString(Object obj) {
        return Objects.toString(obj, "");
    }

    public static String toString(Object obj, String nullStr) {
        return obj == null ? nullStr : obj.toString();
    }

    public static String toReadableString(Object input) {
        return Objects.toReadableString(input, null);
    }

    public static String toReadableString(Object input, String separator) {
        StringBuilder buffer = new StringBuilder();
        if (input instanceof Collection) {
            Collection col = (Collection)input;
            for (Object o : col) {
                buffer.append("{").append(Objects.toString(o, separator)).append("}").append(separator == null ? "," : separator);
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
        } else if (input instanceof Map) {
            Map map = (Map)input;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                buffer.append(Objects.toString(key, separator)).append("=").append("{").append(Objects.toString(value, separator)).append("}").append(separator == null ? "," : separator);
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
        } else if (input != null && input.getClass().isArray()) {
            Object[] array = (Object[])input;
            buffer.append(Objects.toString(Arrays.asList(array), separator));
        } else {
            buffer.append(String.valueOf(input));
        }
        return buffer.toString();
    }

    public static String toStringByAnnotation(Object o) {
        return Objects.toStringByAnnotation(o, o.getClass().getSimpleName());
    }

    public static String toStringByAnnotation(Object o, String prefix) {
        StringBuilder printString = new StringBuilder();
        if (prefix != null) {
            printString.append(prefix).append("[");
        } else {
            printString.append("[");
        }
        Class<?> c = o.getClass();
        printString.append(Objects.getStringPartFieldValue(o, c));
        for (Class<?> superClass = c.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            printString.append(", ");
            printString.append(Objects.getStringPartFieldValue(o, superClass));
        }
        printString.append("]");
        return printString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringPartFieldValue(Object o, Class c) {
        StringBuilder retval = new StringBuilder();
        for (Field f : c.getDeclaredFields()) {
            if (!f.isAnnotationPresent(StringPart.class)) continue;
            boolean accessible = f.isAccessible();
            try {
                f.setAccessible(true);
                Object val = f.get(o);
                StringPart annotation = f.getAnnotation(StringPart.class);
                if (annotation.name() == null || annotation.name().length() == 0) {
                    retval.append(f.getName());
                } else {
                    retval.append(annotation.name());
                }
                retval.append("=").append(val).append(", ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                f.setAccessible(accessible);
            }
        }
        return retval.length() > 2 ? retval.substring(0, retval.length() - 2) : retval.toString();
    }

    public static <T> T narrow(Class<T> clazz, Object obj) {
        if (obj == null || clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        throw Exceptions.make(IllegalArgumentException.class, "Can't cast instance of %s to %s", obj.getClass(), clazz);
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedList interfaces = new LinkedList();
        while (!clazz.equals(Object.class)) {
            Collections.addAll(interfaces, clazz.getInterfaces());
            clazz = clazz.getSuperclass();
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

