/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import me.helloworld.utils.Checker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> T[] copy(T[] orig) {
        if (orig != null) {
            Object[] r = (Object[])Array.newInstance(orig.getClass().getComponentType(), orig.length);
            System.arraycopy(orig, 0, r, 0, orig.length);
            return r;
        }
        return null;
    }

    public static <T, V extends T> int indexOf(T[] array, V value) {
        int r = -1;
        int idx = 0;
        for (T element : array) {
            if (Checker.isEqual(element, value)) {
                r = idx;
                break;
            }
            ++idx;
        }
        return r;
    }

    public static int indexOf(char[] chars, char c) {
        int r = -1;
        int idx = 0;
        for (char ex : chars) {
            if (c == ex) {
                r = idx;
                break;
            }
            ++idx;
        }
        return r;
    }

    public static <T> void fill(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(short[] array, short value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static <T> String join(T[] array, String separator) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.join(array, separator, 0, array.length);
    }

    public static <T> String join(T[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static <T> T[] append(T[] array, T e) {
        Object[] newArr = (Object[])Array.newInstance(e.getClass(), array == null ? 1 : array.length + 1);
        if (array != null && array.length > 0) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArr.length - 1] = e;
        return newArr;
    }

    public static <T> T[] concatArrays(T[] ... arrays) {
        Class<?> clazz = null;
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            if (clazz == null) {
                clazz = array.getClass().getComponentType();
            }
            length += array.length;
        }
        if (clazz == null) {
            return null;
        }
        Object[] newArr = (Object[])Array.newInstance(clazz, length);
        int pos = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, newArr, pos, array.length);
            pos += array.length;
        }
        return newArr;
    }

    public static <T> T[] mergeArrays(T[] ... arrays) {
        Class<?> clazz = null;
        ArrayList<T> result = new ArrayList<T>();
        for (T[] array : arrays) {
            if (array == null) continue;
            if (clazz == null) {
                clazz = array.getClass().getComponentType();
            }
            for (T e : array) {
                if (result.contains(e)) continue;
                result.add(e);
            }
        }
        if (clazz == null) {
            return null;
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static <T> T[] removeDuplicate(T[] array) {
        if (Checker.isEmpty(array)) {
            return array;
        }
        TreeSet result = new TreeSet();
        Collections.addAll(result, array);
        return result.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), result.size()));
    }

    public static <T> T[] sort(T[] array) {
        if (Checker.isEmpty(array)) {
            return (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
        }
        Arrays.sort(array);
        return array;
    }
}

