/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils.collection;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maps {
    public static final Properties EMPTY_PROPERTIES = new Properties();

    public static <K, V> void remove(Map<K, V> map, KVFilter<K, V> filter) {
        ArrayList<K> deleted = null;
        for (Object key : map.keySet()) {
            V value;
            if (!filter.doFilter(key, value = map.get(key))) continue;
            if (deleted == null) {
                deleted = new ArrayList<K>(3);
            }
            deleted.add(key);
        }
        if (deleted != null) {
            for (Object key : deleted) {
                map.remove(key);
            }
            deleted.clear();
        }
        deleted = null;
    }

    public static <K, V> K keyForValue(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map<String, String> makeMap(String[][] params) {
        HashMap<String, String> map = new HashMap<String, String>(params.length);
        for (String[] param : params) {
            map.put(param[0], param[1]);
        }
        return map;
    }

    public static Map<String, String> makeMap(String input) {
        return Maps.makeMap(input, "=", ";");
    }

    public static Map<String, String> makeMap(String input, String separator, String delimiter) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer entryTokenizer = new StringTokenizer(input, delimiter);
        while (entryTokenizer.hasMoreElements()) {
            String entry = entryTokenizer.nextToken();
            int sepIndex = entry.indexOf(separator);
            if (sepIndex > 0) {
                result.put(entry.substring(0, sepIndex), entry.substring(sepIndex + 1));
                continue;
            }
            result.put(entry, null);
        }
        return result;
    }

    public static <T extends Map<?, ?>> T makeMap(Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of args");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return (T)map;
    }

    public static <K, V, MapType extends Map<? super K, ? super V>> MapType makeMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return (MapType)map;
    }

    public static <T extends Map<?, ?>, K extends Enum<K>> T makeEnumMap(Class<K> enumClazz, Object ... args) {
        if (args.length % 2 == 0) {
            throw new IllegalArgumentException("expected even number of args");
        }
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(enumClazz);
        for (int i = 0; i < args.length; i += 2) {
            Enum key = (Enum)enumClazz.cast(args[i]);
            Object value = args[i + 1];
            map.put(key, value);
        }
        return (T)map;
    }

    public static <K, V> String join(Map<K, V> map) {
        return Maps.join(map, "=", ",");
    }

    public static <K, V> String join(Map<K, V> map, String separator, String delimiter) {
        String d = "";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            builder.append(d);
            builder.append(entry.getKey());
            builder.append(separator);
            builder.append(entry.getValue());
            d = delimiter;
        }
        return builder.toString();
    }

    public static String join(Properties properties, String separator, String delimiter) {
        String d = "";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            builder.append(d);
            builder.append(entry.getKey());
            builder.append(separator);
            builder.append(entry.getValue());
            d = delimiter;
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KVFilter<K, V> {
        public boolean doFilter(K var1, V var2);
    }
}

