/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import me.helloworld.utils.Objects;
import me.helloworld.utils.reflect.Members;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fields {
    public static Field findField(Class<?> cls, String fieldName) {
        Field field = Fields.findField(cls, fieldName, false);
        Members.setAccessibleWorkaround(field);
        return field;
    }

    public static Field findField(Class<?> cls, String fieldName, boolean forceAccess) {
        if (cls == null) {
            return null;
        }
        if (fieldName == null) {
            return null;
        }
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class<?> class1 : Objects.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName);
                if (match != null) {
                    throw new IllegalArgumentException("Reference to field " + fieldName + " is ambiguous relative to " + cls + "; a matching field exists on two or more implemented interfaces.");
                }
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return match;
    }

    public static Field findDeclaredField(Class<?> cls, String fieldName) {
        return Fields.findDeclaredField(cls, fieldName, false);
    }

    public static Field findDeclaredField(Class<?> cls, String fieldName, boolean forceAccess) {
        if (cls == null) {
            return null;
        }
        if (fieldName == null) {
            return null;
        }
        try {
            Field field = cls.getDeclaredField(fieldName);
            if (!Members.isAccessible(field)) {
                if (forceAccess) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }
}

