/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ProviderInfo;
import com.cisco.spark.android.core.BackgroundCheck;
import com.cisco.spark.android.core.SquaredContentProvider;
import com.cisco.spark.android.media.MediaEngine;
import com.cisco.spark.android.sync.ConversationContentProvider;
import com.cisco.spark.android.util.UserAgentProvider;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.internal.SparkInjector;
import com.ciscospark.androidsdk.membership.MembershipClient;
import com.ciscospark.androidsdk.membership.internal.MembershipClientImpl;
import com.ciscospark.androidsdk.message.MessageClient;
import com.ciscospark.androidsdk.message.internal.MessageClientImpl;
import com.ciscospark.androidsdk.people.PersonClient;
import com.ciscospark.androidsdk.people.internal.PersonClientImpl;
import com.ciscospark.androidsdk.phone.Phone;
import com.ciscospark.androidsdk.phone.internal.PhoneImpl;
import com.ciscospark.androidsdk.room.RoomClient;
import com.ciscospark.androidsdk.room.internal.RoomClientImpl;
import com.ciscospark.androidsdk.team.TeamClient;
import com.ciscospark.androidsdk.team.TeamMembershipClient;
import com.ciscospark.androidsdk.team.internal.TeamClientImpl;
import com.ciscospark.androidsdk.team.internal.TeamMembershipClientImpl;
import com.ciscospark.androidsdk.utils.log.DebugLn;
import com.ciscospark.androidsdk.utils.log.NoLn;
import com.ciscospark.androidsdk.utils.log.WarningLn;
import com.ciscospark.androidsdk.webhook.WebhookClient;
import com.ciscospark.androidsdk.webhook.internal.WebhookClientImpl;
import com.github.benoitdion.ln.BaseLn;
import com.github.benoitdion.ln.InfoLn;
import com.github.benoitdion.ln.Ln;
import com.github.benoitdion.ln.NaturalLog;
import com.github.benoitdion.ln.ReleaseLn;
import com.webex.wme.MediaSessionAPI;
import javax.inject.Inject;

public class Spark {
    private SparkInjector _injector;
    private Authenticator _authenticator;
    private PhoneImpl _phone;
    @Inject
    MediaEngine _mediaEngine;
    @Inject
    BackgroundCheck _backgroundCheck;

    public Spark(Application application, Authenticator authenticator) {
        SquaredContentProvider.CONTENT_AUTHORITY = Spark.getAuthority(application.getApplicationContext());
        ConversationContentProvider.resetUriMatcher();
        com.cisco.spark.android.core.Application.setApplication((Application)application);
        this._authenticator = authenticator;
        this._injector = new SparkInjector(application);
        this._injector.create();
        this._injector.inject(this);
        this._injector.inject(this._authenticator);
        this._phone = new PhoneImpl(application.getApplicationContext(), this._authenticator, this._injector);
        this.setLogLevel(null);
    }

    public String getVersion() {
        return "0.1.0";
    }

    public void runInBackground(boolean background) {
        if (background) {
            this._backgroundCheck.tryBackground();
        } else {
            this._backgroundCheck.tryForeground();
        }
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public Phone phone() {
        return this._phone;
    }

    public MessageClient messages() {
        return new MessageClientImpl(this._authenticator);
    }

    public PersonClient people() {
        return new PersonClientImpl(this._authenticator);
    }

    public MembershipClient memberships() {
        return new MembershipClientImpl(this._authenticator);
    }

    public TeamClient teams() {
        return new TeamClientImpl(this._authenticator);
    }

    public TeamMembershipClient teamMembershipClient() {
        return new TeamMembershipClientImpl(this._authenticator);
    }

    public WebhookClient webhooks() {
        return new WebhookClientImpl(this._authenticator);
    }

    public RoomClient rooms() {
        return new RoomClientImpl(this._authenticator);
    }

    public void setLogLevel(LogLevel logLevel) {
        BaseLn logger = new DebugLn();
        MediaSessionAPI.TraceLevelMask mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_WARNING;
        if (logLevel != null) {
            switch (logLevel) {
                case NO: {
                    logger = new NoLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_NOTRACE;
                    break;
                }
                case ERROR: {
                    logger = new ReleaseLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_ERROR;
                    break;
                }
                case WARNING: {
                    logger = new WarningLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_WARNING;
                    break;
                }
                case INFO: {
                    logger = new InfoLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_WARNING;
                    break;
                }
                case DEBUG: {
                    logger = new DebugLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_DEBUG;
                    break;
                }
                case VERBOSE: {
                    logger = new com.github.benoitdion.ln.DebugLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_DETAIL;
                    break;
                }
                case ALL: {
                    logger = new com.github.benoitdion.ln.DebugLn();
                    mask = MediaSessionAPI.TraceLevelMask.TRACE_LEVEL_MASK_DETAIL;
                }
            }
        }
        Ln.initialize((NaturalLog)logger);
        if (this._mediaEngine != null) {
            this._mediaEngine.setLoggingLevel(mask);
        }
    }

    private static String getAuthority(Context appContext) {
        try {
            ComponentName componentName = new ComponentName(appContext, ConversationContentProvider.class.getName());
            ProviderInfo providerInfo = appContext.getPackageManager().getProviderInfo(componentName, 0);
            return providerInfo.authority;
        }
        catch (Throwable t) {
            Ln.d((String)"Content provider not found.", (Object[])new Object[0]);
            return "com.ciscospark.androidsdk.CPOSC";
        }
    }

    static {
        UserAgentProvider.APP_NAME = "spark_android_sdk";
        UserAgentProvider.APP_VERSION = "0.0.1";
    }

    public static enum LogLevel {
        NO,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        VERBOSE,
        ALL;

    }
}

