/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.auth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.cisco.spark.android.authenticator.ApiTokenProvider;
import com.cisco.spark.android.authenticator.OAuth2Tokens;
import com.cisco.spark.android.core.AuthenticatedUser;
import com.cisco.spark.android.sync.ActorRecord;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.ciscospark.androidsdk.internal.SparkInjector;
import com.ciscospark.androidsdk.utils.Utils;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import me.helloworld.utils.Converter;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.http.Header;
import retrofit2.http.POST;

public class JWTAuthenticator
implements Authenticator {
    private OAuth2Tokens _token = null;
    private String _jwt;
    private AuthService _authService = new ServiceBuilder().build(AuthService.class);
    @Inject
    ApiTokenProvider _provider;

    @Override
    public boolean isAuthorized() {
        return this.getUnexpiredJwt() != null;
    }

    public void authorize(@NonNull String jwt) {
        this.deauthorize();
        this._jwt = jwt;
    }

    @Override
    public void deauthorize() {
        this._jwt = null;
        this._token = null;
        if (this._provider != null) {
            this._provider.clearAccount();
        }
    }

    @Override
    public void getToken(final @NonNull CompletionHandler<String> handler) {
        Utils.checkNotNull(handler, "CompletionHandler should not be null");
        final String jwt = this.getUnexpiredJwt();
        if (jwt == null) {
            handler.onComplete(ResultImpl.error("JWT is null"));
            return;
        }
        String token = this.getUnexpiredAccessToken();
        if (token != null) {
            handler.onComplete(ResultImpl.success(token));
            return;
        }
        this._authService.getToken(jwt).enqueue((Callback)new Callback<JwtToken>(){

            public void onResponse(Call<JwtToken> call, Response<JwtToken> response) {
                JwtToken token = (JwtToken)response.body();
                if (token == null || token.getAccessToken() == null || token.getAccessToken().isEmpty()) {
                    handler.onComplete(ResultImpl.error(response));
                } else {
                    JWTAuthenticator.this._token = token.toOAuthToken(jwt);
                    if (JWTAuthenticator.this._provider != null) {
                        AuthenticatedUser authenticatedUser = new AuthenticatedUser("", new ActorRecord.ActorKey(""), "", JWTAuthenticator.this._token, "Unknown", null, 0L, null);
                        JWTAuthenticator.this._provider.setAuthenticatedUser(authenticatedUser);
                    }
                    handler.onComplete(ResultImpl.success(JWTAuthenticator.this._token.getAccessToken()));
                }
            }

            public void onFailure(Call<JwtToken> call, Throwable t) {
                handler.onComplete(ResultImpl.error(t));
            }
        });
    }

    @Nullable
    private String getUnexpiredJwt() {
        AuthenticatedUser user;
        if (this._jwt == null && this._token != null) {
            this._jwt = this._token.getRefreshToken();
        }
        if (this._jwt == null && this._provider != null && (user = this._provider.getAuthenticatedUserOrNull()) != null) {
            this._token = user.getOAuth2Tokens();
            this._jwt = this._token.getRefreshToken();
        }
        if (this._jwt == null) {
            return null;
        }
        Map<String, Object> map = this.parseJWT(this._jwt);
        if (map == null) {
            return null;
        }
        try {
            long exp = Converter.toLong((Object)map.get("exp"), (long)-1L);
            if (exp > 0L && exp <= System.currentTimeMillis() / 1000L) {
                return null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this._jwt;
    }

    @Nullable
    private String getUnexpiredAccessToken() {
        AuthenticatedUser user;
        if (!this.isAuthorized()) {
            return null;
        }
        if (this._token == null && this._provider != null && (user = this._provider.getAuthenticatedUserOrNull()) != null) {
            this._token = user.getOAuth2Tokens();
        }
        if (this._token == null || this._token.getExpiresIn() <= System.currentTimeMillis() / 1000L + 900L) {
            return null;
        }
        return this._token.getAccessToken();
    }

    @Nullable
    private Map<String, Object> parseJWT(String jwt) {
        String[] split = jwt.split("\\.");
        if (split.length != 3) {
            return null;
        }
        try {
            String json = new String(Base64.decode((String)split[1], (int)8), "UTF-8");
            Gson gson = new Gson();
            HashMap map = new HashMap();
            return (Map)gson.fromJson(json, map.getClass());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @SparkInjector.AfterInjected
    private void afterInjected() {
        if (this._provider != null && this._token != null) {
            AuthenticatedUser authenticatedUser = new AuthenticatedUser("", new ActorRecord.ActorKey(""), "", this._token, "Unknown", null, 0L, null);
            this._provider.setAuthenticatedUser(authenticatedUser);
        }
    }

    private class JwtToken {
        @SerializedName(value="expiresIn")
        long expiresIn;
        @SerializedName(value="token")
        String accessToken;

        private JwtToken() {
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        String getAccessToken() {
            return this.accessToken;
        }

        OAuth2Tokens toOAuthToken(String jwt) {
            OAuth2Tokens tokens = new OAuth2Tokens();
            tokens.setAccessToken(this.getAccessToken());
            tokens.setExpiresIn(this.getExpiresIn() + System.currentTimeMillis() / 1000L);
            tokens.setRefreshToken(this.getAccessToken());
            return tokens;
        }
    }

    static interface AuthService {
        @POST(value="jwt/login")
        public Call<JwtToken> getToken(@Header(value="Authorization") String var1);
    }
}

