/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.auth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.cisco.spark.android.authenticator.ApiTokenProvider;
import com.cisco.spark.android.authenticator.OAuth2Tokens;
import com.cisco.spark.android.core.AuthenticatedUser;
import com.cisco.spark.android.sync.ActorRecord;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.ciscospark.androidsdk.internal.SparkInjector;
import com.ciscospark.androidsdk.utils.Utils;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import com.github.benoitdion.ln.Ln;
import javax.inject.Inject;
import me.helloworld.utils.Checker;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

public class OAuthAuthenticator
implements Authenticator {
    private String _clientId;
    private String _clientSecret;
    private String _scope;
    private String _redirectUri;
    private OAuth2Tokens _token;
    private AuthService _authService;
    @Inject
    ApiTokenProvider _provider;

    public OAuthAuthenticator(@NonNull String clientId, @NonNull String clientSecret, @NonNull String scope, @NonNull String redirectUri) {
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this._redirectUri = redirectUri;
        this._scope = scope;
        this._authService = new ServiceBuilder().build(AuthService.class);
    }

    @Override
    public boolean isAuthorized() {
        return this.getToken() != null;
    }

    @Override
    public void deauthorize() {
        this._token = null;
        if (this._provider != null) {
            this._provider.clearAccount();
        }
    }

    public void authorize(@NonNull String code, final @NonNull CompletionHandler<Void> handler) {
        Utils.checkNotNull(handler, "CompletionHandler is null");
        Ln.d((String)("Authorize: " + code), (Object[])new Object[0]);
        this._authService.getToken(this._clientId, this._clientSecret, this._redirectUri, "authorization_code", code).enqueue((Callback)new Callback<OAuth2Tokens>(){

            public void onResponse(Call<OAuth2Tokens> call, Response<OAuth2Tokens> response) {
                OAuthAuthenticator.this._token = (OAuth2Tokens)response.body();
                Ln.d((String)("Authorize: " + OAuthAuthenticator.this._token + ", " + OAuthAuthenticator.this._provider), (Object[])new Object[0]);
                if (OAuthAuthenticator.this._token == null || OAuthAuthenticator.this._token.getAccessToken() == null || OAuthAuthenticator.this._token.getAccessToken().isEmpty()) {
                    handler.onComplete(ResultImpl.error(response));
                } else {
                    OAuthAuthenticator.this._token.setExpiresIn(OAuthAuthenticator.this._token.getExpiresIn() + System.currentTimeMillis() / 1000L);
                    if (OAuthAuthenticator.this._provider != null) {
                        AuthenticatedUser authenticatedUser = new AuthenticatedUser("", new ActorRecord.ActorKey(""), "", OAuthAuthenticator.this._token, "Unknown", null, 0L, null);
                        OAuthAuthenticator.this._provider.setAuthenticatedUser(authenticatedUser);
                    }
                    handler.onComplete(ResultImpl.success(null));
                }
            }

            public void onFailure(Call<OAuth2Tokens> call, Throwable t) {
                handler.onComplete(ResultImpl.error(t));
            }
        });
    }

    @Override
    public void getToken(final @NonNull CompletionHandler<String> handler) {
        Utils.checkNotNull(handler, "CompletionHandler is null");
        OAuth2Tokens token = this.getToken();
        Ln.d((String)("GetToken: " + token + ", " + this._provider), (Object[])new Object[0]);
        if (token == null) {
            handler.onComplete(ResultImpl.error("Not authorized"));
            return;
        }
        if (!Checker.isEmpty((CharSequence)token.getAccessToken()) && token.getExpiresIn() > System.currentTimeMillis() / 1000L + 900L) {
            handler.onComplete(ResultImpl.success(token.getAccessToken()));
            return;
        }
        this._authService.refreshToken(this._clientId, this._clientSecret, token.getRefreshToken(), "refresh_token").enqueue((Callback)new Callback<OAuth2Tokens>(){

            public void onResponse(Call<OAuth2Tokens> call, Response<OAuth2Tokens> response) {
                OAuthAuthenticator.this._token = (OAuth2Tokens)response.body();
                if (OAuthAuthenticator.this._token == null || Checker.isEmpty((CharSequence)OAuthAuthenticator.this._token.getAccessToken())) {
                    handler.onComplete(ResultImpl.error(response));
                } else {
                    OAuthAuthenticator.this._token.setExpiresIn(OAuthAuthenticator.this._token.getExpiresIn() + System.currentTimeMillis() / 1000L);
                    if (OAuthAuthenticator.this._provider != null) {
                        AuthenticatedUser authenticatedUser = new AuthenticatedUser("", new ActorRecord.ActorKey(""), "", OAuthAuthenticator.this._token, "Unknown", null, 0L, null);
                        OAuthAuthenticator.this._provider.setAuthenticatedUser(authenticatedUser);
                    }
                    handler.onComplete(ResultImpl.success(OAuthAuthenticator.this._token.getAccessToken()));
                }
            }

            public void onFailure(Call<OAuth2Tokens> call, Throwable t) {
                handler.onComplete(ResultImpl.error(t));
            }
        });
    }

    @Nullable
    private OAuth2Tokens getToken() {
        if (this._token == null && this._provider != null) {
            AuthenticatedUser user = this._provider.getAuthenticatedUserOrNull();
            Ln.d((String)("Get user: " + user + ", " + this._provider), (Object[])new Object[0]);
            if (user != null) {
                this._token = user.getOAuth2Tokens();
            }
        }
        if (this._token == null || this._token.getExpiresIn() <= System.currentTimeMillis() / 1000L + 900L) {
            Ln.d((String)("Check token: " + this._token + ", " + this._provider), (Object[])new Object[0]);
            if (this._token != null) {
                Ln.d((String)("Check token: " + this._token.getExpiresIn() + ", " + System.currentTimeMillis() / 1000L + 900 + ", " + this._provider), (Object[])new Object[0]);
            }
            return null;
        }
        return this._token;
    }

    @SparkInjector.AfterInjected
    private void afterInjected() {
        if (this._provider != null && this._token != null) {
            AuthenticatedUser authenticatedUser = new AuthenticatedUser("", new ActorRecord.ActorKey(""), "", this._token, "Unknown", null, 0L, null);
            this._provider.setAuthenticatedUser(authenticatedUser);
        }
    }

    protected String getClientId() {
        return this._clientId;
    }

    protected String getClientSecret() {
        return this._clientSecret;
    }

    protected String getScope() {
        return this._scope;
    }

    protected String getRedirectUri() {
        return this._redirectUri;
    }

    static interface AuthService {
        @FormUrlEncoded
        @POST(value="access_token")
        public Call<OAuth2Tokens> getToken(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="redirect_uri") String var3, @Field(value="grant_type") String var4, @Field(value="code") String var5);

        @FormUrlEncoded
        @POST(value="access_token")
        public Call<OAuth2Tokens> refreshToken(@Field(value="client_id") String var1, @Field(value="client_secret") String var2, @Field(value="refresh_token") String var3, @Field(value="grant_type") String var4);
    }
}

