/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.auth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import android.webkit.WebView;
import com.cisco.spark.android.core.Injector;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.Result;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.auth.OAuthAuthenticator;
import com.ciscospark.androidsdk.auth.OAuthWebViewAuthenticator$$Lambda$1;
import com.ciscospark.androidsdk.auth.internal.OAuthLauncher;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.ciscospark.androidsdk.internal.SparkInjector;
import javax.inject.Inject;
import me.helloworld.utils.Checker;

public class OAuthWebViewAuthenticator
implements Authenticator {
    private static final String TAG = OAuthWebViewAuthenticator.class.getSimpleName();
    private CompletionHandler<Void> _callback;
    private OAuthAuthenticator _authenticator;
    private OAuthLauncher _launcher;
    @Inject
    Injector _injector;

    public OAuthWebViewAuthenticator(@NonNull String clientId, @NonNull String clientSecret, @NonNull String scope, @NonNull String redirectUri) {
        this._authenticator = new OAuthAuthenticator(clientId, clientSecret, redirectUri, scope);
        this._launcher = new OAuthLauncher();
    }

    @Override
    public boolean isAuthorized() {
        return this._authenticator.isAuthorized();
    }

    @Override
    public void deauthorize() {
        this._authenticator.deauthorize();
    }

    public void authorize(@NonNull WebView view, @NonNull CompletionHandler<Void> handler) {
        this._launcher.launchOAuthView(view, this.buildCodeGrantUrl(), this._authenticator.getRedirectUri(), OAuthWebViewAuthenticator$$Lambda$1.lambdaFactory$(this, handler));
    }

    @Override
    public void getToken(CompletionHandler<String> handler) {
        this._authenticator.getToken(handler);
    }

    private String buildCodeGrantUrl() {
        Uri.Builder builder = Uri.parse((String)"https://api.ciscospark.com/v1/").buildUpon();
        builder.appendPath("authorize").appendQueryParameter("response_type", "code").appendQueryParameter("client_id", this._authenticator.getClientId()).appendQueryParameter("redirect_uri", this._authenticator.getRedirectUri()).appendQueryParameter("scope", this._authenticator.getScope()).appendQueryParameter("state", "androidsdkstate");
        return builder.toString();
    }

    @SparkInjector.AfterInjected
    private void afterInjected() {
        Log.d((String)TAG, (String)"Inject authenticator after self injected");
        this._injector.inject((Object)this._authenticator);
    }

    static /* synthetic */ void lambda$authorize$0(@NonNull OAuthWebViewAuthenticator this_, CompletionHandler handler, Result result) {
        Log.d((String)TAG, (String)("authorize: " + result));
        String code = (String)result.getData();
        if (!Checker.isEmpty((CharSequence)code)) {
            this_._authenticator.authorize(code, handler);
        } else {
            handler.onComplete(ResultImpl.error(result.getError()));
        }
    }
}

