/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.auth.internal;

import android.annotation.TargetApi;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.CookieManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.Result;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.github.benoitdion.ln.Ln;
import me.helloworld.utils.Checker;

public class OAuthLauncher {
    public void launchOAuthView(WebView view, String authorizationUrl, String redirectUri, CompletionHandler<String> handler) {
        BrowserWebViewClient client = new BrowserWebViewClient(authorizationUrl, redirectUri, handler);
        view.clearCache(true);
        view.setWebViewClient((WebViewClient)client);
        WebSettings webSettings = view.getSettings();
        webSettings.setSupportZoom(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSaveFormData(false);
        webSettings.setAllowFileAccess(false);
        webSettings.setCacheMode(2);
        CookieManager.getInstance().setAcceptCookie(true);
        CookieManager.getInstance().removeAllCookie();
        view.loadUrl(authorizationUrl);
    }

    private class BrowserWebViewClient
    extends WebViewClient {
        private String _url;
        private String _redirectUri;
        private CompletionHandler<String> _handler;

        BrowserWebViewClient(String url, String redirectUri, CompletionHandler<String> handler) {
            this._url = url;
            this._redirectUri = redirectUri;
            this._handler = handler;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Ln.d((String)("Loading " + url), (Object[])new Object[0]);
            if (url.startsWith(this._redirectUri.toLowerCase())) {
                Uri uri = Uri.parse((String)url);
                String code = uri.getQueryParameter("code");
                if (Checker.isEmpty((CharSequence)code)) {
                    this._handler.onComplete(ResultImpl.error("Auth code isn't exist"));
                    return false;
                }
                view.clearCache(true);
                view.loadUrl("about:blank");
                this.handleResult(ResultImpl.success(code));
                return false;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        @TargetApi(value=23)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Ln.e((String)("Receive: " + errorCode + ", " + description), (Object[])new Object[0]);
            this.handleResult(ResultImpl.error(errorCode + " " + description));
            super.onReceivedError(view, errorCode, description, failingUrl);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            Ln.e((String)("Receive SSL Error: " + error), (Object[])new Object[0]);
            handler.cancel();
            if (error != null) {
                this.handleResult(ResultImpl.error(error.toString()));
            }
        }

        private void handleResult(Result<String> result) {
            if (this._handler != null) {
                this._handler.onComplete(result);
                this._handler = null;
            }
        }
    }
}

