/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.internal;

import com.cisco.spark.android.features.CoreFeatures;
import com.cisco.spark.android.wdm.DeviceRegistration;
import com.cisco.spark.android.wdm.Features;

public class AppFeatures
implements CoreFeatures {
    private final DeviceRegistration deviceRegistration;

    public AppFeatures(DeviceRegistration deviceRegistration) {
        this.deviceRegistration = deviceRegistration;
    }

    public boolean isFilesActivityEnabled() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-view-media", false);
    }

    public boolean isAnnotationFileEnable() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-board-annotation-file", false) && this.isWhiteboardEnabled();
    }

    public boolean isAnnotationPresentationEnable() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-board-annotation-presentation", false) && this.isWhiteboardEnabled();
    }

    public boolean isWhiteboardEnabled() {
        return false;
    }

    public boolean isNativeWhiteboardEnabled() {
        return true;
    }

    public boolean isLockWhiteboardToLandscapeEnabled() {
        return false;
    }

    public boolean isSendWhiteboardEnabled() {
        return this.deviceRegistration.getFeatures().isAnyToggleEnabled(new String[]{"android-send-whiteboard-ea1", "android-send-whiteboard"});
    }

    public boolean isDeleteWhiteboardEnabled() {
        return this.deviceRegistration.getFeatures().isAnyToggleEnabled(new String[]{"android-delete-whiteboard"});
    }

    public boolean isWhiteBoardAddGuestAclEnabled() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-whiteboard-add-guest-acl", false);
    }

    public boolean isAnnotationEnabled() {
        return false;
    }

    public boolean isRoapEnabled() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-roap-enabled", false);
    }

    public int getMaxRosterSize() {
        int defaultMaxRosterSize = this.getMaxBridgeSize();
        return this.deviceRegistration.getFeatures().getFeatureInt("locus-max-roster-participants", Features.FeatureType.DEVELOPER, defaultMaxRosterSize);
    }

    public int getMaxBridgeSize() {
        int defaultMaxBridgeSize = 12;
        return this.deviceRegistration.getFeatures().getFeatureInt("bridge-max-conv-participants", Features.FeatureType.DEVELOPER, 12);
    }

    public int getMeetUrlMaxConvParticipants() {
        int defaultMeetUrlMaxConvParticipants = this.getMaxBridgeSize();
        return this.deviceRegistration.getFeatures().getFeatureInt("meet-url-max-conv-participants", Features.FeatureType.DEVELOPER, defaultMeetUrlMaxConvParticipants);
    }

    public boolean uploadCallLogs() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("upload-call-logs", false);
    }

    public boolean isNumericDialingEnabled() {
        return this.deviceRegistration.getFeatures().isFeatureEnabled("numeric-dialing", Features.FeatureType.DEVELOPER, false);
    }

    public boolean isCallSpinnerEnabled() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-call-spinner", false);
    }

    public boolean isDeltaEventEnabled() {
        return this.deviceRegistration.getFeatures().isDeveloperFeatureEnabled("android-locus-delta-event", false);
    }

    public boolean isSegmentMetricsEnabled() {
        return true;
    }
}

