/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.internal;

import com.ciscospark.androidsdk.Result;
import com.ciscospark.androidsdk.SparkError;
import java.io.IOException;
import me.helloworld.utils.Objects;
import me.helloworld.utils.annotation.StringPart;
import retrofit2.Response;

public class ResultImpl<T>
implements Result<T> {
    @StringPart
    private T _data;
    @StringPart
    private SparkError _error;

    public static <T> Result<T> success(T data) {
        return new ResultImpl<T>(data, null);
    }

    public static <T> Result<T> error(String message) {
        return new ResultImpl<Object>(null, new SparkError(SparkError.ErrorCode.UNEXPECTED_ERROR, message));
    }

    public static <T> Result<T> error(Throwable t) {
        return new ResultImpl<Object>(null, ResultImpl.makeError(t));
    }

    public static <T> Result<T> error(SparkError error) {
        return new ResultImpl<Object>(null, error);
    }

    public static <T> Result<T> error(Response response) {
        return new ResultImpl<Object>(null, ResultImpl.makeError(response));
    }

    public ResultImpl(T data, SparkError error) {
        this._data = data;
        this._error = error;
    }

    @Override
    public boolean isSuccessful() {
        return this._error == null;
    }

    @Override
    public SparkError getError() {
        return this._error;
    }

    @Override
    public T getData() {
        return this._data;
    }

    public String toString() {
        return Objects.toStringByAnnotation((Object)this);
    }

    private static SparkError makeError(Throwable t) {
        return new SparkError(SparkError.ErrorCode.UNEXPECTED_ERROR, t.toString());
    }

    private static SparkError makeError(Response res) {
        StringBuilder message = new StringBuilder().append(res.code()).append("/").append(res.message());
        try {
            String body = res.errorBody().string();
            message.append("/").append(body);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new SparkError(SparkError.ErrorCode.SERVICE_ERROR, message.toString());
    }
}

