/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.membership.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.membership.Membership;
import com.ciscospark.androidsdk.membership.MembershipClient;
import com.ciscospark.androidsdk.membership.internal.MembershipClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.membership.internal.MembershipClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.membership.internal.MembershipClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.membership.internal.MembershipClientImpl$$Lambda$4;
import com.ciscospark.androidsdk.membership.internal.MembershipClientImpl$$Lambda$5;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.collection.Maps;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class MembershipClientImpl
implements MembershipClient {
    private Authenticator _authenticator;
    private MembershipService _service;

    public MembershipClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(MembershipService.class);
    }

    @Override
    public void list(@Nullable String roomId, @Nullable String personId, @Nullable String personEmail, int max, @NonNull CompletionHandler<List<Membership>> handler) {
        ServiceBuilder.async(this._authenticator, handler, MembershipClientImpl$$Lambda$1.lambdaFactory$(this, roomId, personId, personEmail, max, handler));
    }

    @Override
    public void create(@NonNull String roomId, @Nullable String personId, @Nullable String personEmail, boolean isModerator, @NonNull CompletionHandler<Membership> handler) {
        ServiceBuilder.async(this._authenticator, handler, MembershipClientImpl$$Lambda$2.lambdaFactory$(this, roomId, personId, personEmail, isModerator, handler));
    }

    @Override
    public void get(@NonNull String membershipId, @NonNull CompletionHandler<Membership> handler) {
        ServiceBuilder.async(this._authenticator, handler, MembershipClientImpl$$Lambda$3.lambdaFactory$(this, membershipId, handler));
    }

    @Override
    public void update(@NonNull String membershipId, boolean isModerator, @NonNull CompletionHandler<Membership> handler) {
        ServiceBuilder.async(this._authenticator, handler, MembershipClientImpl$$Lambda$4.lambdaFactory$(this, membershipId, isModerator, handler));
    }

    @Override
    public void delete(@NonNull String membershipId, @NonNull CompletionHandler<Void> handler) {
        ServiceBuilder.async(this._authenticator, handler, MembershipClientImpl$$Lambda$5.lambdaFactory$(this, membershipId, handler));
    }

    static /* synthetic */ void lambda$delete$4(@NonNull MembershipClientImpl this_, @NonNull String membershipId, CompletionHandler handler, String s) {
        this_._service.delete(s, membershipId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$update$3(@NonNull MembershipClientImpl this_, String membershipId, @NonNull boolean isModerator, CompletionHandler handler, String s) {
        this_._service.update(s, membershipId, Maps.makeMap((Object)"isModerator", (Object)isModerator)).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$2(@NonNull MembershipClientImpl this_, @NonNull String membershipId, CompletionHandler handler, String s) {
        this_._service.get(s, membershipId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$create$1(@NonNull MembershipClientImpl this_, @Nullable String roomId, @Nullable String personId, String personEmail, @NonNull boolean isModerator, CompletionHandler handler, String s) {
        this_._service.create(s, Maps.makeMap((Object[])new Object[]{"roomId", roomId, "personId", personId, "personEmail", personEmail, "isModerator", isModerator})).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(@Nullable MembershipClientImpl this_, @Nullable String roomId, @Nullable String personId, String personEmail, @NonNull int max, CompletionHandler handler, String s) {
        this_._service.list(s, roomId, personId, personEmail, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface MembershipService {
        @GET(value="memberships")
        public Call<ListBody<Membership>> list(@Header(value="Authorization") String var1, @Query(value="roomId") String var2, @Query(value="personId") String var3, @Query(value="personEmail") String var4, @Query(value="max") Integer var5);

        @POST(value="memberships")
        public Call<Membership> create(@Header(value="Authorization") String var1, @Body Map var2);

        @GET(value="memberships/{membershipId}")
        public Call<Membership> get(@Header(value="Authorization") String var1, @Path(value="membershipId") String var2);

        @PUT(value="memberships/{membershipId}")
        public Call<Membership> update(@Header(value="Authorization") String var1, @Path(value="membershipId") String var2, @Body Map var3);

        @DELETE(value="memberships/{membershipId}")
        public Call<Void> delete(@Header(value="Authorization") String var1, @Path(value="membershipId") String var2);
    }
}

