/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.message.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.message.Message;
import com.ciscospark.androidsdk.message.MessageClient;
import com.ciscospark.androidsdk.message.internal.MessageClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.message.internal.MessageClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.message.internal.MessageClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.message.internal.MessageClientImpl$$Lambda$4;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.collection.Maps;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class MessageClientImpl
implements MessageClient {
    private Authenticator _authenticator;
    private MessageService _service;

    public MessageClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(MessageService.class);
    }

    @Override
    public void list(@NonNull String roomId, @Nullable String before, @Nullable String beforeMessage, @Nullable String mentionedPeople, int max, @NonNull CompletionHandler<List<Message>> handler) {
        ServiceBuilder.async(this._authenticator, handler, MessageClientImpl$$Lambda$1.lambdaFactory$(this, roomId, before, beforeMessage, mentionedPeople, max, handler));
    }

    @Override
    public void post(@Nullable String roomId, @Nullable String personId, @Nullable String personEmail, @Nullable String text, @Nullable String markdown, @Nullable String[] files, @NonNull CompletionHandler<Message> handler) {
        ServiceBuilder.async(this._authenticator, handler, MessageClientImpl$$Lambda$2.lambdaFactory$(this, roomId, personId, personEmail, text, markdown, files, handler));
    }

    @Override
    public void get(@NonNull String messageId, @NonNull CompletionHandler<Message> handler) {
        ServiceBuilder.async(this._authenticator, handler, MessageClientImpl$$Lambda$3.lambdaFactory$(this, messageId, handler));
    }

    @Override
    public void delete(@NonNull String messageId, @NonNull CompletionHandler<Void> handler) {
        ServiceBuilder.async(this._authenticator, handler, MessageClientImpl$$Lambda$4.lambdaFactory$(this, messageId, handler));
    }

    static /* synthetic */ void lambda$delete$3(@NonNull MessageClientImpl this_, @NonNull String messageId, CompletionHandler handler, String s) {
        this_._service.delete(s, messageId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$2(@NonNull MessageClientImpl this_, @NonNull String messageId, CompletionHandler handler, String s) {
        this_._service.get(s, messageId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$post$1(@Nullable MessageClientImpl this_, @Nullable String roomId, @Nullable String personId, @Nullable String personEmail, @Nullable String text, @Nullable String markdown, @NonNull String[] files, CompletionHandler handler, String s) {
        this_._service.post(s, Maps.makeMap((Object[])new Object[]{"roomId", roomId, "toPersonId", personId, "toPersonEmail", personEmail, "text", text, "markdown", markdown, "files", files})).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(@NonNull MessageClientImpl this_, @Nullable String roomId, @Nullable String before, @Nullable String beforeMessage, String mentionedPeople, @NonNull int max, CompletionHandler handler, String s) {
        this_._service.list(s, roomId, before, beforeMessage, mentionedPeople, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface MessageService {
        @GET(value="messages")
        public Call<ListBody<Message>> list(@Header(value="Authorization") String var1, @Query(value="roomId") String var2, @Query(value="before") String var3, @Query(value="beforeMessage") String var4, @Query(value="mentionedPeople") String var5, @Query(value="max") Integer var6);

        @POST(value="messages")
        public Call<Message> post(@Header(value="Authorization") String var1, @Body Map var2);

        @GET(value="messages/{messageId}")
        public Call<Message> get(@Header(value="Authorization") String var1, @Path(value="messageId") String var2);

        @DELETE(value="messages/{messageId}")
        public Call<Void> delete(@Header(value="Authorization") String var1, @Path(value="messageId") String var2);
    }
}

