/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.people.internal;

import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.people.Person;
import com.ciscospark.androidsdk.people.PersonClient;
import com.ciscospark.androidsdk.people.internal.PersonClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.people.internal.PersonClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.people.internal.PersonClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class PersonClientImpl
implements PersonClient {
    private Authenticator _authenticator;
    private PersonService _service;

    public PersonClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(PersonService.class);
    }

    @Override
    public void list(String email, String displayName, int max, CompletionHandler<List<Person>> handler) {
        ServiceBuilder.async(this._authenticator, handler, PersonClientImpl$$Lambda$1.lambdaFactory$(this, email, displayName, max, handler));
    }

    @Override
    public void get(String personId, CompletionHandler<Person> handler) {
        ServiceBuilder.async(this._authenticator, handler, PersonClientImpl$$Lambda$2.lambdaFactory$(this, personId, handler));
    }

    @Override
    public void getMe(CompletionHandler<Person> handler) {
        ServiceBuilder.async(this._authenticator, handler, PersonClientImpl$$Lambda$3.lambdaFactory$(this, handler));
    }

    static /* synthetic */ void lambda$getMe$2(PersonClientImpl this_, CompletionHandler handler, String s) {
        this_._service.getMe(s).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$1(PersonClientImpl this_, String personId, CompletionHandler handler, String s) {
        this_._service.get(s, personId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(PersonClientImpl this_, String email, String displayName, int max, CompletionHandler handler, String s) {
        this_._service.list(s, email, displayName, null, null, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface PersonService {
        @GET(value="people")
        public Call<ListBody<Person>> list(@Header(value="Authorization") String var1, @Query(value="email") String var2, @Query(value="displayName") String var3, @Query(value="id") String var4, @Query(value="orgId") String var5, @Query(value="max") Integer var6);

        @GET(value="people/{personId}")
        public Call<Person> get(@Header(value="Authorization") String var1, @Path(value="personId") String var2);

        @GET(value="people/me")
        public Call<Person> getMe(@Header(value="Authorization") String var1);
    }
}

