/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.phone;

import com.ciscospark.androidsdk.SparkError;
import com.ciscospark.androidsdk.phone.Call;
import me.helloworld.utils.Objects;
import me.helloworld.utils.annotation.StringPart;

public interface CallObserver {
    public void onRinging(Call var1);

    public void onConnected(Call var1);

    public void onDisconnected(CallDisconnectedEvent var1);

    public void onMediaChanged(MediaChangedEvent var1);

    public static class RemoteVideoViewSizeChanged
    extends AbstractCallEvent
    implements MediaChangedEvent {
        public RemoteVideoViewSizeChanged(Call call) {
            super(call);
        }
    }

    public static class LocalVideoViewSizeChanged
    extends AbstractCallEvent
    implements MediaChangedEvent {
        public LocalVideoViewSizeChanged(Call call) {
            super(call);
        }
    }

    public static class CameraSwitched
    extends AbstractCallEvent
    implements MediaChangedEvent {
        public CameraSwitched(Call call) {
            super(call);
        }
    }

    public static class ReceivingAudio
    extends AbstractCallEvent
    implements MediaChangedEvent {
        @StringPart
        private boolean _receiving;

        public ReceivingAudio(Call call, boolean receiving) {
            super(call);
            this._receiving = receiving;
        }

        public boolean isSending() {
            return this._receiving;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static class ReceivingVideo
    extends AbstractCallEvent
    implements MediaChangedEvent {
        @StringPart
        private boolean _receiving;

        public ReceivingVideo(Call call, boolean receiving) {
            super(call);
            this._receiving = receiving;
        }

        public boolean isSending() {
            return this._receiving;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static class SendingAudio
    extends AbstractCallEvent
    implements MediaChangedEvent {
        @StringPart
        private boolean _sending;

        public SendingAudio(Call call, boolean sending) {
            super(call);
            this._sending = sending;
        }

        public boolean isSending() {
            return this._sending;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static class SendingVideo
    extends AbstractCallEvent
    implements MediaChangedEvent {
        @StringPart
        private boolean _sending;

        public SendingVideo(Call call, boolean sending) {
            super(call);
            this._sending = sending;
        }

        public boolean isSending() {
            return this._sending;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static class RemoteSendingAudioEvent
    extends AbstractCallEvent
    implements MediaChangedEvent {
        @StringPart
        private boolean _sending;

        public RemoteSendingAudioEvent(Call call, boolean sending) {
            super(call);
            this._sending = sending;
        }

        public boolean isSending() {
            return this._sending;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static class RemoteSendingVideoEvent
    extends AbstractCallEvent
    implements MediaChangedEvent {
        @StringPart
        private boolean _sending;

        public RemoteSendingVideoEvent(Call call, boolean sending) {
            super(call);
            this._sending = sending;
        }

        public boolean isSending() {
            return this._sending;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static interface MediaChangedEvent
    extends CallEvent {
    }

    public static class CallErrorEvent
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        @StringPart
        private SparkError _error;

        public CallErrorEvent(Call call, SparkError error) {
            super(call);
            this._error = error;
        }

        public SparkError getError() {
            return this._error;
        }

        @Override
        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static class OtherDeclined
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public OtherDeclined(Call call) {
            super(call);
        }
    }

    public static class OtherConnected
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public OtherConnected(Call call) {
            super(call);
        }
    }

    public static class RemoteCancel
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public RemoteCancel(Call call) {
            super(call);
        }
    }

    public static class RemoteDecline
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public RemoteDecline(Call call) {
            super(call);
        }
    }

    public static class RemoteLeft
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public RemoteLeft(Call call) {
            super(call);
        }
    }

    public static class LocalCancel
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public LocalCancel(Call call) {
            super(call);
        }
    }

    public static class LocalDecline
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public LocalDecline(Call call) {
            super(call);
        }
    }

    public static class LocalLeft
    extends AbstractCallEvent
    implements CallDisconnectedEvent {
        public LocalLeft(Call call) {
            super(call);
        }
    }

    public static interface CallDisconnectedEvent
    extends CallEvent {
    }

    public static abstract class AbstractCallEvent
    implements CallEvent {
        @StringPart
        protected Call _call;

        protected AbstractCallEvent(Call call) {
            this._call = call;
        }

        @Override
        public Call getCall() {
            return this._call;
        }

        public String toString() {
            return Objects.toStringByAnnotation((Object)this);
        }
    }

    public static interface CallEvent {
        public Call getCall();
    }
}

