/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.phone.internal;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.cisco.spark.android.callcontrol.events.CallControlMediaDecodeSizeChangedEvent;
import com.cisco.spark.android.events.OperationCompletedEvent;
import com.cisco.spark.android.locus.model.Locus;
import com.cisco.spark.android.locus.model.LocusData;
import com.cisco.spark.android.locus.model.LocusKey;
import com.cisco.spark.android.locus.model.LocusParticipant;
import com.cisco.spark.android.locus.model.LocusSelfRepresentation;
import com.cisco.spark.android.locus.model.MediaDirection;
import com.cisco.spark.android.media.MediaRequestSource;
import com.cisco.spark.android.media.MediaSession;
import com.cisco.spark.android.sync.operationqueue.SendDtmfOperation;
import com.cisco.spark.android.sync.operationqueue.core.Operation;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.ciscospark.androidsdk.phone.Call;
import com.ciscospark.androidsdk.phone.CallMembership;
import com.ciscospark.androidsdk.phone.CallObserver;
import com.ciscospark.androidsdk.phone.MediaOption;
import com.ciscospark.androidsdk.phone.Phone;
import com.ciscospark.androidsdk.phone.internal.CallMembershipImpl;
import com.ciscospark.androidsdk.phone.internal.PhoneImpl;
import com.github.benoitdion.ln.Ln;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.Objects;
import me.helloworld.utils.annotation.StringPart;

public class CallImpl
implements Call {
    @NonNull
    private PhoneImpl _phone;
    @StringPart
    @NonNull
    private Call.CallStatus _status;
    @StringPart
    @NonNull
    private Call.Direction _direction;
    @StringPart
    @NonNull
    private LocusKey _key;
    private CallObserver _observer;
    private Rect _localVideoViewSize = new Rect(0, 0, 0, 0);
    private Rect _remoteVideoViewSize = new Rect(0, 0, 0, 0);
    private Map<SendDtmfOperation, CompletionHandler<Void>> _dtmfOperations = new HashMap<SendDtmfOperation, CompletionHandler<Void>>(1);

    CallImpl(@NonNull PhoneImpl phone, @NonNull Call.Direction direction, @NonNull LocusKey key) {
        this._phone = phone;
        this._direction = direction;
        this._key = key;
        this._status = Call.CallStatus.INITIATED;
    }

    @NonNull
    LocusKey getKey() {
        return this._key;
    }

    void setStatus(@NonNull Call.CallStatus status) {
        this._status = status;
    }

    @Override
    @NonNull
    public Call.CallStatus getStatus() {
        return this._status;
    }

    @Override
    @NonNull
    public Call.Direction getDirection() {
        return this._direction;
    }

    @Override
    public void setObserver(CallObserver observer) {
        this._observer = observer;
    }

    @Override
    public CallObserver getObserver() {
        return this._observer;
    }

    @Override
    public List<CallMembership> getMemberships() {
        List<LocusParticipant> participants = this.getParticipants();
        ArrayList<CallMembership> memberships = new ArrayList<CallMembership>(participants.size());
        for (LocusParticipant p : participants) {
            memberships.add(new CallMembershipImpl(p));
        }
        return memberships;
    }

    @Override
    public CallMembership getFrom() {
        for (CallMembership membership : this.getMemberships()) {
            if (!membership.isInitiator()) continue;
            return membership;
        }
        return null;
    }

    @Override
    public CallMembership getTo() {
        for (CallMembership membership : this.getMemberships()) {
            if (membership.isInitiator()) continue;
            return membership;
        }
        return null;
    }

    @Override
    public Rect getLocalVideoViewSize() {
        return this._localVideoViewSize;
    }

    @Override
    public Rect getRemoteVideoViewSize() {
        return this._remoteVideoViewSize;
    }

    @Override
    public boolean isRemoteSendingVideo() {
        for (LocusParticipant p : this.getRemoteParticipants()) {
            if ((p.getState() != LocusParticipant.State.JOINED || !p.getStatus().getVideoStatus().equals((Object)MediaDirection.SENDONLY)) && !p.getStatus().getVideoStatus().equals((Object)MediaDirection.SENDRECV)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRemoteSendingAudio() {
        for (LocusParticipant p : this.getRemoteParticipants()) {
            if ((p.getState() != LocusParticipant.State.JOINED || !p.getStatus().getAudioStatus().equals((Object)MediaDirection.SENDONLY)) && !p.getStatus().getAudioStatus().equals((Object)MediaDirection.SENDRECV)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSendingVideo() {
        return !this._phone.getCallService().isVideoMuted(this.getKey());
    }

    @Override
    public void setSendingVideo(boolean sending) {
        if (sending) {
            this._phone.getCallService().unMuteVideo(this.getKey(), MediaRequestSource.USER);
        } else {
            this._phone.getCallService().muteVideo(this.getKey(), MediaRequestSource.USER);
        }
    }

    @Override
    public boolean isSendingAudio() {
        return !this._phone.getCallService().isAudioMuted(this.getKey());
    }

    @Override
    public void setSendingAudio(boolean sending) {
        if (sending) {
            this._phone.getCallService().unmuteAudio(this.getKey());
        } else {
            this._phone.getCallService().muteAudio(this.getKey());
        }
    }

    @Override
    public boolean isReceivingVideo() {
        return !this._phone.getCallService().isRemoteVideoMuted(this.getKey());
    }

    @Override
    public void setReceivingVideo(boolean receiving) {
        this._phone.getCallService().muteRemoteVideos(this.getKey(), !receiving);
        CallObserver observer = this.getObserver();
        if (observer != null) {
            observer.onMediaChanged(new CallObserver.ReceivingVideo(this, receiving));
        }
    }

    @Override
    public boolean isReceivingAudio() {
        return this._phone.getCallService().isRemoteAudioMuted(this.getKey());
    }

    @Override
    public void setReceivingAudio(boolean receiving) {
        this._phone.getCallService().muteRemoteAudio(this.getKey(), !receiving);
        CallObserver observer = this.getObserver();
        if (observer != null) {
            observer.onMediaChanged(new CallObserver.ReceivingAudio(this, receiving));
        }
    }

    @Override
    public void acknowledge(@NonNull CompletionHandler<Void> callback) {
        this._phone.getCallService().acknowledge(this.getKey());
        this.setStatus(Call.CallStatus.RINGING);
        callback.onComplete(null);
    }

    @Override
    public void answer(@NonNull MediaOption option, @NonNull CompletionHandler<Void> callback) {
        this._phone.answer(this, option, callback);
    }

    @Override
    public void reject(@NonNull CompletionHandler<Void> callback) {
        this._phone.reject(this, callback);
    }

    @Override
    public void hangup(@NonNull CompletionHandler<Void> callback) {
        this._phone.hangup(this, callback);
    }

    @Override
    public boolean isSendingDTMFEnabled() {
        LocusSelfRepresentation self = this.getSelf();
        return self != null && self.isEnableDTMF();
    }

    @Override
    public void sendDTMF(@NonNull String dtmf, @NonNull CompletionHandler<Void> callback) {
        SendDtmfOperation operation = this._phone.getOperationQueue().sendDtmf(dtmf);
        this._dtmfOperations.put(operation, callback);
    }

    @Override
    public void sendFeedback(int rating, @Nullable String comment) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("user.rating", String.valueOf(rating));
        info.put("user.comments", comment);
        info.put("locusId", this._key.getLocusId());
        Locus locus = this._phone.getCallService().getLocus(this._key);
        if (locus != null && locus.getSelf() != null) {
            info.put("participantId", locus.getSelf().getId().toString());
        }
        this._phone.sendFeedback(info);
    }

    @Override
    public Phone.FacingMode getFacingMode() {
        com.cisco.spark.android.callcontrol.model.Call call = this._phone.getCallService().getCall(this.getKey());
        if (call == null) {
            return this._phone.getDefaultFacingMode();
        }
        MediaSession session = call.getMediaSession();
        if (session == null) {
            return this._phone.getDefaultFacingMode();
        }
        return PhoneImpl.toFacingMode(session.getSelectedCamera());
    }

    @Override
    public void setFacingMode(Phone.FacingMode facingMode) {
        CallObserver observer;
        MediaSession session;
        com.cisco.spark.android.callcontrol.model.Call call = this._phone.getCallService().getCall(this.getKey());
        if (call != null && (session = call.getMediaSession()) != null && session.setSelectedCameraAndChangeDevice(PhoneImpl.fromFacingMode(facingMode)) && (observer = this.getObserver()) != null) {
            observer.onMediaChanged(new CallObserver.CameraSwitched(this));
        }
    }

    public void onEventMainThread(CallControlMediaDecodeSizeChangedEvent event) {
        Ln.d((String)"CallControlMediaDecodeSizeChangedEvent is received", (Object[])new Object[0]);
        this._remoteVideoViewSize = event.getSize();
        CallObserver observer = this.getObserver();
        if (observer != null) {
            observer.onMediaChanged(new CallObserver.RemoteVideoViewSizeChanged(this));
        }
    }

    public void onEventMainThread(MediaSession.MediaRenderSizeChangedEvent event) {
        Ln.d((String)"MediaRenderSizeChangedEvent is received", (Object[])new Object[0]);
        this._localVideoViewSize = event.size;
        CallObserver observer = this.getObserver();
        if (observer != null) {
            observer.onMediaChanged(new CallObserver.LocalVideoViewSizeChanged(this));
        }
    }

    public void onEventMainThread(OperationCompletedEvent event) {
        CompletionHandler<Void> callback;
        Ln.d((String)"OperationCompletedEvent is received", (Object[])new Object[0]);
        Operation operation = event.getOperation();
        if (operation != null && (callback = this._dtmfOperations.get(operation)) != null) {
            if (operation.isSucceeded()) {
                callback.onComplete(ResultImpl.success(null));
            } else {
                callback.onComplete(ResultImpl.error(operation.getErrorMessage()));
            }
        }
    }

    public String toString() {
        return Objects.toStringByAnnotation((Object)this);
    }

    LocusSelfRepresentation getSelf() {
        LocusData locusData = this._phone.getCallService().getLocusData(this.getKey());
        if (locusData == null) {
            return null;
        }
        Locus locus = locusData.getLocus();
        if (locus == null) {
            return null;
        }
        return locus.getSelf();
    }

    private List<LocusParticipant> getParticipants() {
        LocusData locusData = this._phone.getCallService().getLocusData(this.getKey());
        if (locusData == null) {
            return new ArrayList<LocusParticipant>(0);
        }
        Locus locus = locusData.getLocus();
        if (locus == null) {
            return new ArrayList<LocusParticipant>(0);
        }
        return locus.getParticipants();
    }

    private List<LocusParticipant> getRemoteParticipants() {
        List<LocusParticipant> participants = this.getParticipants();
        LocusSelfRepresentation self = this.getSelf();
        if (self == null) {
            return participants;
        }
        ArrayList<LocusParticipant> ret = new ArrayList<LocusParticipant>(participants.size() - 1);
        for (LocusParticipant p : participants) {
            if (self.getId().equals(p.getId())) continue;
            ret.add(p);
        }
        return ret;
    }
}

