/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.phone.internal;

import com.cisco.spark.android.locus.model.LocusParticipant;
import com.cisco.spark.android.locus.model.LocusParticipantInfo;
import com.cisco.spark.android.locus.model.MediaDirection;
import com.ciscospark.androidsdk.phone.CallMembership;
import me.helloworld.utils.Objects;
import me.helloworld.utils.annotation.StringPart;

public class CallMembershipImpl
implements CallMembership {
    @StringPart
    private boolean _isInitiator = false;
    @StringPart
    private String _personId;
    @StringPart
    private CallMembership.State _state = CallMembership.State.UNKNOWN;
    @StringPart
    private String _email;
    @StringPart
    private String _sipUrl;
    @StringPart
    private String _phoneNumber;
    @StringPart
    private boolean _sendingVideo = false;
    @StringPart
    private boolean _sendingAudio = false;

    private static CallMembership.State fromLocusState(LocusParticipant.State state) {
        if (state == LocusParticipant.State.IDLE) {
            return CallMembership.State.IDLE;
        }
        if (state == LocusParticipant.State.NOTIFIED) {
            return CallMembership.State.NOTIFIED;
        }
        if (state == LocusParticipant.State.JOINED) {
            return CallMembership.State.JOINED;
        }
        if (state == LocusParticipant.State.LEFT) {
            return CallMembership.State.LEFT;
        }
        if (state == LocusParticipant.State.DECLINED) {
            return CallMembership.State.DECLINED;
        }
        if (state == LocusParticipant.State.LEAVING) {
            return CallMembership.State.LEFT;
        }
        return CallMembership.State.UNKNOWN;
    }

    CallMembershipImpl(LocusParticipant participant) {
        LocusParticipantInfo person = participant.getPerson();
        this._personId = person.getId();
        this._email = person.getEmail();
        this._phoneNumber = person.getPhoneNumber();
        this._sipUrl = person.getPhoneNumber();
        this._isInitiator = participant.isCreator();
        this._state = CallMembershipImpl.fromLocusState(participant.getState());
        this._sendingVideo = MediaDirection.SENDRECV.equals((Object)participant.getStatus().getVideoStatus());
        this._sendingAudio = MediaDirection.SENDRECV.equals((Object)participant.getStatus().getAudioStatus());
    }

    @Override
    public boolean isInitiator() {
        return this._isInitiator;
    }

    @Override
    public String getPersonId() {
        return this._personId;
    }

    @Override
    public CallMembership.State getState() {
        return this._state;
    }

    @Override
    public String getEmail() {
        return this._email;
    }

    @Override
    public String getSipUrl() {
        return this._sipUrl;
    }

    @Override
    public String getPhoneNumber() {
        return this._phoneNumber;
    }

    @Override
    public boolean isSendingVideo() {
        return this._sendingVideo;
    }

    @Override
    public boolean isSendingAudio() {
        return this._sendingAudio;
    }

    public String toString() {
        return Objects.toStringByAnnotation((Object)this);
    }
}

