/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.phone.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.github.benoitdion.ln.Ln;

public class H264LicensePrompter {
    private SharedPreferences _preferences;

    H264LicensePrompter(SharedPreferences preferences) {
        this._preferences = preferences;
    }

    String getLicense() {
        return "To enable video calls, activate a free video license (H.264 AVC) from Cisco. By selecting 'Activate', you accept the Cisco End User License Agreement and Notices.";
    }

    String getLicenseURL() {
        return "http://www.openh264.org/BINARY_LICENSE.txt";
    }

    void check(@NonNull AlertDialog.Builder builder, final @NonNull CompletionHandler<Boolean> handler) {
        if (this.isVideoLicenseActivated() || this.isVideoLicenseActivationDisabled()) {
            handler.onComplete(true);
        } else {
            final Context context = builder.getContext();
            builder.setTitle((CharSequence)"Activate License");
            builder.setMessage((CharSequence)this.getLicense());
            builder.setPositiveButton((CharSequence)"Activate", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Ln.i((String)"Video license has been activated", (Object[])new Object[0]);
                    H264LicensePrompter.this.setVideoLicenseActivated(true);
                    handler.onComplete(true);
                }
            });
            builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Ln.i((String)"Video license has not been activated", (Object[])new Object[0]);
                    dialog.cancel();
                    handler.onComplete(false);
                }
            });
            builder.setNeutralButton((CharSequence)"View License", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Ln.i((String)"Video license opened for viewing", (Object[])new Object[0]);
                    Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)H264LicensePrompter.this.getLicenseURL()));
                    context.startActivity(browserIntent);
                    dialog.cancel();
                    handler.onComplete(false);
                }
            });
            AlertDialog diag = builder.create();
            diag.show();
        }
    }

    boolean isVideoLicenseActivationDisabled() {
        return this._preferences.getBoolean("isVideoLicenseActivationDisabledKey", false);
    }

    void setVideoLicenseActivationDisabled(boolean disabled) {
        this._preferences.edit().putBoolean("isVideoLicenseActivationDisabledKey", disabled).apply();
    }

    void reset() {
        this.setVideoLicenseActivationDisabled(false);
        this.setVideoLicenseActivated(false);
    }

    private boolean isVideoLicenseActivated() {
        return this._preferences.getBoolean("isVideoLicenseActivatedKey", false);
    }

    private void setVideoLicenseActivated(boolean activated) {
        this._preferences.edit().putBoolean("isVideoLicenseActivatedKey", activated).apply();
    }

    public static interface CompletionHandler<T> {
        public void onComplete(T var1);
    }
}

