/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.phone.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.Base64;
import android.view.View;
import com.cisco.spark.android.authenticator.AuthenticatedUserTask;
import com.cisco.spark.android.callcontrol.CallContext;
import com.cisco.spark.android.callcontrol.CallControlService;
import com.cisco.spark.android.callcontrol.events.CallControlCallCancelledEvent;
import com.cisco.spark.android.callcontrol.events.CallControlCallJoinErrorEvent;
import com.cisco.spark.android.callcontrol.events.CallControlLeaveLocusEvent;
import com.cisco.spark.android.callcontrol.events.CallControlLocalAudioMutedEvent;
import com.cisco.spark.android.callcontrol.events.CallControlLocalVideoMutedEvent;
import com.cisco.spark.android.callcontrol.events.CallControlLocusChangedEvent;
import com.cisco.spark.android.callcontrol.events.CallControlLocusCreatedEvent;
import com.cisco.spark.android.callcontrol.events.CallControlParticipantAudioMuteEvent;
import com.cisco.spark.android.callcontrol.events.CallControlParticipantJoinedEvent;
import com.cisco.spark.android.callcontrol.events.CallControlParticipantLeftEvent;
import com.cisco.spark.android.callcontrol.events.CallControlParticipantVideoMutedEvent;
import com.cisco.spark.android.callcontrol.events.CallControlSelfParticipantLeftEvent;
import com.cisco.spark.android.callcontrol.events.DismissCallNotificationEvent;
import com.cisco.spark.android.core.ApiClientProvider;
import com.cisco.spark.android.core.ApplicationController;
import com.cisco.spark.android.events.ApplicationControllerStateChangedEvent;
import com.cisco.spark.android.events.CallNotificationEvent;
import com.cisco.spark.android.events.CallNotificationType;
import com.cisco.spark.android.events.DeviceRegistrationChangedEvent;
import com.cisco.spark.android.events.RequestCallingPermissions;
import com.cisco.spark.android.locus.events.LocusDeclinedEvent;
import com.cisco.spark.android.locus.events.ParticipantNotifiedEvent;
import com.cisco.spark.android.locus.events.RetrofitErrorEvent;
import com.cisco.spark.android.locus.model.LocusData;
import com.cisco.spark.android.locus.model.LocusKey;
import com.cisco.spark.android.locus.model.LocusSelfRepresentation;
import com.cisco.spark.android.media.MediaEngine;
import com.cisco.spark.android.media.MediaSession;
import com.cisco.spark.android.media.events.StunTraceServerResultEvent;
import com.cisco.spark.android.metrics.CallAnalyzerReporter;
import com.cisco.spark.android.sync.operationqueue.core.OperationQueue;
import com.cisco.spark.android.sync.queue.ConversationSyncQueue;
import com.cisco.spark.android.wdm.DeviceRegistration;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.Result;
import com.ciscospark.androidsdk.Spark;
import com.ciscospark.androidsdk.SparkError;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.internal.MetricsClient;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.ciscospark.androidsdk.internal.SparkInjector;
import com.ciscospark.androidsdk.people.Person;
import com.ciscospark.androidsdk.people.internal.PersonClientImpl;
import com.ciscospark.androidsdk.phone.Call;
import com.ciscospark.androidsdk.phone.CallObserver;
import com.ciscospark.androidsdk.phone.MediaOption;
import com.ciscospark.androidsdk.phone.Phone;
import com.ciscospark.androidsdk.phone.internal.CallImpl;
import com.ciscospark.androidsdk.phone.internal.H264LicensePrompter;
import com.ciscospark.androidsdk.phone.internal.PhoneImpl$$Lambda$1;
import com.ciscospark.androidsdk.phone.internal.PhoneImpl$$Lambda$4;
import com.ciscospark.androidsdk.phone.internal.PhoneImpl$$Lambda$5;
import com.ciscospark.androidsdk.utils.Utils;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import com.github.benoitdion.ln.Ln;
import de.greenrobot.event.EventBus;
import de.greenrobot.event.NoSubscriberEvent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import me.helloworld.utils.Checker;

public class PhoneImpl
implements Phone {
    @Inject
    ApplicationController _applicationController;
    @Inject
    ApiClientProvider apiClientProvider;
    @Inject
    CallControlService _callControlService;
    @Inject
    OperationQueue _operationQueue;
    @Inject
    MediaEngine _mediaEngine;
    @Inject
    EventBus _bus;
    @Inject
    CallAnalyzerReporter _callAnalyzerReporter;
    private Phone.IncomingCallListener _incomingCallListener;
    private Authenticator _authenticator;
    private DeviceRegistration _device;
    private Handler _registerTimer;
    private Runnable _registerTimeoutTask;
    private CompletionHandler<Void> _registerCallback;
    private Map<LocusKey, CallImpl> _calls = new HashMap<LocusKey, CallImpl>();
    private CompletionHandler<Call> _dialCallback;
    private CompletionHandler<Void> _incomingCallback;
    private MediaOption _option;
    private MediaSession _preview;
    private H264LicensePrompter _prompter;
    private MetricsClient _metrics;

    public PhoneImpl(Context context, Authenticator authenticator, SparkInjector injector) {
        injector.inject(this);
        this._authenticator = authenticator;
        this._bus.register((Object)this);
        this._registerTimer = new Handler();
        this._prompter = new H264LicensePrompter(context.getSharedPreferences(Spark.class.getPackage().getName(), 0));
    }

    @Override
    public Phone.IncomingCallListener getIncomingCallListener() {
        return this._incomingCallListener;
    }

    @Override
    public void setIncomingCallListener(Phone.IncomingCallListener listener) {
        this._incomingCallListener = listener;
    }

    public void close() {
        if (this._bus.isRegistered((Object)this)) {
            this._bus.unregister((Object)this);
        }
    }

    @Override
    public Phone.FacingMode getDefaultFacingMode() {
        return PhoneImpl.toFacingMode(this._callControlService.getDefaultCamera());
    }

    @Override
    public void setDefaultFacingMode(Phone.FacingMode mode) {
        this._callControlService.setDefaultCamera(PhoneImpl.fromFacingMode(mode));
    }

    @Override
    public void requestVideoCodecActivation(@NonNull AlertDialog.Builder builder, @NonNull CompletionHandler<Boolean> callback) {
        this._prompter.check(builder, PhoneImpl$$Lambda$1.lambdaFactory$(callback));
    }

    @Override
    public String getVideoCodecLicense() {
        return this._prompter.getLicense();
    }

    @Override
    public String getVideoCodecLicenseURL() {
        return this._prompter.getLicenseURL();
    }

    @Override
    public void disableVideoCodecActivation() {
        this._prompter.setVideoLicenseActivationDisabled(true);
    }

    @Override
    public void register(@NonNull CompletionHandler<Void> callback) {
        Ln.i((String)"Registering", (Object[])new Object[0]);
        if (this._registerCallback != null) {
            Ln.w((String)"Already registering", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("Already registering"));
            return;
        }
        this._registerCallback = callback;
        ServiceBuilder.async(this._authenticator, callback, PhoneImpl$$Lambda$4.lambdaFactory$(this));
    }

    @Override
    public void deregister(@NonNull CompletionHandler<Void> callback) {
        Ln.i((String)"Deregistering", (Object[])new Object[0]);
        this._applicationController.logout(null, false, false, false);
        this._mediaEngine.uninitialize();
        this._device = null;
        this._registerCallback = null;
        this._registerTimer.removeCallbacks(this._registerTimeoutTask);
        callback.onComplete(ResultImpl.success(null));
        Ln.i((String)"Deregistered", (Object[])new Object[0]);
    }

    @Override
    public void startPreview(View view) {
        this.stopPreview();
        this._preview = this._mediaEngine.createMediaSession(UUID.randomUUID().toString());
        this._preview.setSelectedCamera(this._callControlService.getDefaultCamera());
        this._preview.setPreviewWindow(view);
        this._preview.startSelfView();
    }

    @Override
    public void stopPreview() {
        if (this._preview != null) {
            this._preview.endSession();
            this._preview = null;
        }
    }

    @Override
    public void dial(final @NonNull String dialString, final @NonNull MediaOption option, @NonNull CompletionHandler<Call> callback) {
        Ln.i((String)("Dialing: " + dialString + ", " + option.hasVideo()), (Object[])new Object[0]);
        if (this._device == null) {
            Ln.e((String)"Unregistered device", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("Unregistered device"));
            return;
        }
        if (this._dialCallback != null) {
            Ln.w((String)"Already calling", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("Already calling"));
            return;
        }
        if (this._calls.size() > 0) {
            Ln.e((String)"There are other active calls", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("There are other active calls"));
            return;
        }
        this.stopPreview();
        this._option = option;
        this._dialCallback = callback;
        if (dialString.contains("@") && !dialString.contains(".")) {
            new PersonClientImpl(this._authenticator).list(dialString, null, 1, new CompletionHandler<List<Person>>(){

                @Override
                public void onComplete(Result<List<Person>> result) {
                    List<Person> persons = result.getData();
                    if (!Checker.isEmpty(persons)) {
                        Person person = persons.get(0);
                        Ln.d((String)("Lookup target: " + person.getId()), (Object[])new Object[0]);
                        PhoneImpl.this.doDial(PhoneImpl.this.parseHydraId(person.getId()), option);
                    } else {
                        PhoneImpl.this.doDial(PhoneImpl.this.parseHydraId(dialString), option);
                    }
                }
            });
        } else {
            this.doDial(this.parseHydraId(dialString), option);
        }
    }

    void answer(@NonNull CallImpl call, @NonNull MediaOption option, @NonNull CompletionHandler<Void> callback) {
        Ln.i((String)("Answer " + call), (Object[])new Object[0]);
        for (CallImpl exist : this._calls.values()) {
            if (exist.getKey().equals((Object)call.getKey()) || exist.getStatus() != Call.CallStatus.CONNECTED) continue;
            Ln.e((String)"There are other active calls", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("There are other active calls"));
            return;
        }
        if (call.getDirection() == Call.Direction.OUTGOING) {
            Ln.e((String)"Unsupport function for outgoing call", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("Unsupport function for outgoing call"));
            return;
        }
        if (call.getDirection() == Call.Direction.INCOMING) {
            if (call.getStatus() == Call.CallStatus.CONNECTED) {
                Ln.e((String)"Already connected", (Object[])new Object[0]);
                callback.onComplete(ResultImpl.error("Already connected"));
                return;
            }
            if (call.getStatus() == Call.CallStatus.DISCONNECTED) {
                Ln.e((String)"Already disconnected", (Object[])new Object[0]);
                callback.onComplete(ResultImpl.error("Already disconnected"));
                return;
            }
        }
        this.stopPreview();
        this._option = option;
        this._incomingCallback = callback;
        CallContext.Builder builder = new CallContext.Builder(call.getKey()).setIsAnsweringCall(true).setIsOneOnOne(true);
        if (!option.hasVideo()) {
            builder = builder.setMediaDirection(MediaEngine.MediaDirection.SendReceiveAudioOnly);
        }
        this._callControlService.joinCall(builder.build());
    }

    void reject(@NonNull CallImpl call, @NonNull CompletionHandler<Void> callback) {
        Ln.i((String)("Reject " + call), (Object[])new Object[0]);
        if (call.getDirection() == Call.Direction.OUTGOING) {
            Ln.e((String)"Unsupport function for outgoing call", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("Unsupport function for outgoing call"));
            return;
        }
        if (call.getDirection() == Call.Direction.INCOMING) {
            if (call.getStatus() == Call.CallStatus.CONNECTED) {
                Ln.e((String)"Already connected", (Object[])new Object[0]);
                callback.onComplete(ResultImpl.error("Already connected"));
                return;
            }
            if (call.getStatus() == Call.CallStatus.DISCONNECTED) {
                Ln.e((String)"Already disconnected", (Object[])new Object[0]);
                callback.onComplete(ResultImpl.error("Already disconnected"));
                return;
            }
        }
        this._incomingCallback = callback;
        this._callControlService.declineCall(call.getKey());
    }

    void hangup(@NonNull CallImpl call, @NonNull CompletionHandler<Void> callback) {
        Ln.i((String)("Hangup " + call), (Object[])new Object[0]);
        if (call.getStatus() == Call.CallStatus.DISCONNECTED) {
            Ln.e((String)"Already disconnected", (Object[])new Object[0]);
            callback.onComplete(ResultImpl.error("Already disconnected"));
            return;
        }
        this._incomingCallback = callback;
        if (call.getStatus() == Call.CallStatus.INITIATED || call.getStatus() == Call.CallStatus.RINGING) {
            this._callControlService.cancelCall(call.getKey(), CallControlService.CancelReason.LOCAL_CANCELLED);
        } else {
            this._callControlService.leaveCall(call.getKey());
        }
    }

    private void _removeCall(@NonNull CallObserver.CallDisconnectedEvent event) {
        CallImpl call = (CallImpl)event.getCall();
        Ln.i((String)("Remove " + call), (Object[])new Object[0]);
        if (call != null) {
            call.setStatus(Call.CallStatus.DISCONNECTED);
            CallObserver observer = call.getObserver();
            if (observer != null) {
                observer.onDisconnected(event);
            }
            this._calls.remove(call.getKey());
            if (this._bus.isRegistered((Object)call)) {
                this._bus.unregister((Object)call);
            }
        }
    }

    void sendFeedback(Map<String, String> feedback) {
        if (this._metrics != null) {
            feedback.put("key", "meetup_call_user_rating");
            feedback.put("time", Utils.timestampUTC());
            feedback.put("type", "GENERIC");
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            list.add(feedback);
            this._metrics.post(list);
        }
    }

    CallControlService getCallService() {
        return this._callControlService;
    }

    OperationQueue getOperationQueue() {
        return this._operationQueue;
    }

    public void onEventMainThread(DeviceRegistrationChangedEvent event) {
        Ln.i((String)"DeviceRegistrationChangedEvent is received ", (Object[])new Object[0]);
        this._device = event.getDeviceRegistration();
        Uri uri = this._device.getMetricsServiceUrl();
        if (uri != null) {
            String url = uri.toString();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            this._metrics = new MetricsClient(this._authenticator, url);
        }
        if (this._registerCallback == null) {
            Ln.w((String)"Register callback is null ", (Object[])new Object[0]);
            return;
        }
        this._registerCallback.onComplete(ResultImpl.success(null));
        this._registerCallback = null;
        this._registerTimer.removeCallbacks(this._registerTimeoutTask);
        Ln.i((String)("Registered: " + event.getDeviceRegistration().getId()), (Object[])new Object[0]);
    }

    public void onEventMainThread(CallControlLocusCreatedEvent event) {
        Ln.i((String)("CallControlLocusCreatedEventis received " + event.getLocusKey()), (Object[])new Object[0]);
        LocusKey key = event.getLocusKey();
        CallImpl call = this._calls.get(key);
        if (call == null) {
            com.cisco.spark.android.callcontrol.model.Call locus = this._callControlService.getCall(key);
            if (locus != null) {
                call = new CallImpl(this, Call.Direction.OUTGOING, key);
                this._bus.register((Object)call);
                this._calls.put(key, call);
                if (this._dialCallback != null) {
                    this._dialCallback.onComplete(ResultImpl.success(call));
                }
            } else {
                Ln.e((String)("Internal callImpl isn't exist " + event.getLocusKey()), (Object[])new Object[0]);
                if (this._dialCallback != null) {
                    this._dialCallback.onComplete(ResultImpl.error("Internal callImpl isn't exist"));
                }
                this._option = null;
            }
            this._dialCallback = null;
        }
    }

    public void onEventMainThread(ParticipantNotifiedEvent event) {
        Ln.i((String)("ParticipantNotifiedEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            call.setStatus(Call.CallStatus.RINGING);
            CallObserver observer = call.getObserver();
            if (observer != null) {
                observer.onRinging(call);
            }
        }
    }

    public void onEventMainThread(CallControlParticipantJoinedEvent event) {
        Ln.i((String)("CallControlParticipantJoinedEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            CallObserver observer;
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            if (this._option != null && this._option.hasVideo()) {
                this._callControlService.setRemoteWindow(event.getLocusKey(), this._option.getRemoteView());
                this._callControlService.setPreviewWindow(event.getLocusKey(), this._option.getLocalView());
            }
            call.setStatus(Call.CallStatus.CONNECTED);
            if (this._incomingCallback != null) {
                this._incomingCallback.onComplete(ResultImpl.success(null));
                this._incomingCallback = null;
            }
            if ((observer = call.getObserver()) != null) {
                observer.onConnected(call);
            }
        }
    }

    public void onEventMainThread(RetrofitErrorEvent event) {
        Ln.e((String)"RetrofitErrorEvent is received ", (Object[])new Object[0]);
        this.clearCallback(ResultImpl.error("Error"));
    }

    public void onEventMainThread(CallControlCallJoinErrorEvent event) {
        Ln.e((String)"CallControlCallJoinErrorEvent is received ", (Object[])new Object[0]);
        this.clearCallback(ResultImpl.error("Join Error"));
    }

    public void onEventMainThread(CallControlSelfParticipantLeftEvent event) {
        Ln.i((String)("CallControlSelfParticipantLeftEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            if (this._incomingCallback != null) {
                this._incomingCallback.onComplete(ResultImpl.success(null));
                this._incomingCallback = null;
            }
            this._removeCall(new CallObserver.LocalLeft(call));
        }
    }

    public void onEventMainThread(LocusDeclinedEvent event) {
        Ln.i((String)("LocusDeclinedEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            if (this._incomingCallback != null) {
                this._incomingCallback.onComplete(ResultImpl.success(null));
                this._incomingCallback = null;
            }
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            this._removeCall(new CallObserver.LocalDecline(call));
        }
    }

    public void onEventMainThread(CallControlCallCancelledEvent event) {
        Ln.i((String)("CallControlCallCancelledEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            if (event.getReason() == CallControlService.CancelReason.REMOTE_CANCELLED) {
                this._removeCall(new CallObserver.RemoteCancel(call));
            } else {
                if (this._incomingCallback != null) {
                    this._incomingCallback.onComplete(ResultImpl.success(null));
                    this._incomingCallback = null;
                }
                this._removeCall(new CallObserver.LocalCancel(call));
            }
        }
    }

    public void onEventMainThread(CallControlParticipantLeftEvent event) {
        Ln.i((String)("CallControlParticipantLeftEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            this._removeCall(new CallObserver.RemoteLeft(call));
        }
    }

    public void onEventMainThread(CallControlLeaveLocusEvent event) {
        Ln.i((String)("CallControlLeaveLocusEvent is received " + event.locusData().getKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.locusData().getKey());
        if (!(call == null || event.wasMediaFlowing() || event.wasUCCall() || event.wasRoomCall() || event.wasRoomCallConnected())) {
            Ln.d((String)("Find callImpl " + event.locusData().getKey()), (Object[])new Object[0]);
            this._removeCall(new CallObserver.RemoteDecline(call));
        }
    }

    public void onEventMainThread(CallNotificationEvent event) {
        Ln.i((String)("CallNotificationEvent is received " + event.getType()), (Object[])new Object[0]);
        if (event.getType() == CallNotificationType.INCOMING) {
            Ln.i((String)("InComing Call " + event.getLocusKey()), (Object[])new Object[0]);
            CallImpl call = new CallImpl(this, Call.Direction.INCOMING, event.getLocusKey());
            this._bus.register((Object)call);
            this._calls.put(call.getKey(), call);
            Phone.IncomingCallListener listener = this.getIncomingCallListener();
            if (listener != null) {
                listener.onIncomingCall(call);
            }
        }
    }

    public void onEventMainThread(DismissCallNotificationEvent event) {
        Ln.i((String)("DismissCallNotificationEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        LocusData call = this._callControlService.getLocusData(event.getLocusKey());
        if (call != null) {
            call.setIsToasting(false);
        }
        this._callAnalyzerReporter.reportCallAlertRemoved(event.getLocusKey());
    }

    public void onEventMainThread(CallControlLocalAudioMutedEvent event) {
        Ln.i((String)("CallControlLocalAudioMutedEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            CallObserver observer = call.getObserver();
            if (observer != null) {
                observer.onMediaChanged(new CallObserver.SendingAudio(call, !event.isMuted()));
            }
        }
    }

    public void onEventMainThread(CallControlLocalVideoMutedEvent event) {
        Ln.i((String)("CallControlLocalVideoMutedEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            CallObserver observer = call.getObserver();
            if (observer != null) {
                observer.onMediaChanged(new CallObserver.SendingVideo(call, !event.isMuted()));
            }
        }
    }

    public void onEventMainThread(CallControlParticipantAudioMuteEvent event) {
        Ln.i((String)("CallControlParticipantAudioMuteEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            CallObserver observer;
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            LocusSelfRepresentation self = call.getSelf();
            if (!(self != null && self.getUrl().equals((Object)event.getParticipant().getUrl()) || (observer = call.getObserver()) == null)) {
                observer.onMediaChanged(new CallObserver.RemoteSendingAudioEvent(call, !event.isMuted()));
            }
        }
    }

    public void onEventMainThread(CallControlParticipantVideoMutedEvent event) {
        Ln.i((String)("CallControlParticipantVideoMutedEvent is received " + event.getLocusKey()), (Object[])new Object[0]);
        CallImpl call = this._calls.get(event.getLocusKey());
        if (call != null) {
            CallObserver observer;
            Ln.d((String)("Find callImpl " + event.getLocusKey()), (Object[])new Object[0]);
            LocusSelfRepresentation self = call.getSelf();
            if (!(self != null && self.getUrl().equals((Object)event.getParticipant().getUrl()) || (observer = call.getObserver()) == null)) {
                observer.onMediaChanged(new CallObserver.RemoteSendingVideoEvent(call, !event.isMuted()));
            }
        }
    }

    public void onEventMainThread(CallControlLocusChangedEvent event) {
        Ln.i((String)"CallControlLocusChangedEvent is received ", (Object[])new Object[0]);
    }

    public void onEventMainThread(RequestCallingPermissions event) {
        Ln.i((String)"RequestCallingPermissions is received", (Object[])new Object[0]);
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("android.permission.RECORD_AUDIO");
        permissions.add("android.permission.CAMERA");
        this.clearCallback(ResultImpl.error(new SparkError(SparkError.ErrorCode.PERMISSION_ERROR, "Permissions Error", permissions)));
    }

    private void clearCallback(Result result) {
        this._option = null;
        if (this._dialCallback != null) {
            this._dialCallback.onComplete(result);
            this._dialCallback = null;
        }
        if (this._incomingCallback != null) {
            this._incomingCallback.onComplete(result);
            this._incomingCallback = null;
        }
    }

    private void doDial(String target, MediaOption option) {
        Ln.d((String)("Dial " + target), (Object[])new Object[0]);
        CallContext.Builder builder = new CallContext.Builder(target);
        if (!option.hasVideo()) {
            builder = builder.setMediaDirection(MediaEngine.MediaDirection.SendReceiveAudioOnly);
        }
        this._callControlService.joinCall(builder.build());
    }

    private String parseHydraId(String id) {
        try {
            List paths;
            byte[] bytes = Base64.decode((String)id, (int)8);
            if (Checker.isEmpty((byte[])bytes)) {
                return id;
            }
            String decode = new String(bytes, "UTF-8");
            Uri uri = Uri.parse((String)decode);
            if (uri != null && uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("ciscospark") && (paths = uri.getPathSegments()) != null && paths.size() >= 2) {
                return (String)paths.get(paths.size() - 1);
            }
            return id;
        }
        catch (UnsupportedEncodingException e) {
            return id;
        }
    }

    static Phone.FacingMode toFacingMode(String s) {
        if ("0".equals(s)) {
            return Phone.FacingMode.ENVIROMENT;
        }
        return Phone.FacingMode.USER;
    }

    static String fromFacingMode(Phone.FacingMode mode) {
        if (mode == Phone.FacingMode.ENVIROMENT) {
            return "0";
        }
        return "1";
    }

    public void onEventMainThread(NoSubscriberEvent event) {
    }

    public void onEventMainThread(ConversationSyncQueue.ConversationSyncStartedEvent event) {
    }

    public void onEventMainThread(StunTraceServerResultEvent event) {
    }

    public void onEventMainThread(ApplicationControllerStateChangedEvent event) {
    }

    static /* synthetic */ void lambda$register$2(PhoneImpl this_, String s) {
        this_._registerTimeoutTask = PhoneImpl$$Lambda$5.lambdaFactory$(this_);
        this_._registerTimer.postDelayed(this_._registerTimeoutTask, 60000L);
        new AuthenticatedUserTask(this_._applicationController).execute();
    }

    static /* synthetic */ void lambda$null$1(PhoneImpl this_) {
        Ln.i((String)"Register timeout", (Object[])new Object[0]);
        if (this_._device == null && this_._registerCallback != null) {
            this_._registerCallback.onComplete(ResultImpl.error("Register timeout"));
        }
    }

    static /* synthetic */ void lambda$requestVideoCodecActivation$0(@NonNull CompletionHandler callback, Boolean result) {
        callback.onComplete(ResultImpl.success(result));
    }
}

