/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.room.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.room.Room;
import com.ciscospark.androidsdk.room.RoomClient;
import com.ciscospark.androidsdk.room.internal.RoomClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.room.internal.RoomClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.room.internal.RoomClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.room.internal.RoomClientImpl$$Lambda$4;
import com.ciscospark.androidsdk.room.internal.RoomClientImpl$$Lambda$5;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.collection.Maps;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class RoomClientImpl
implements RoomClient {
    private Authenticator _authenticator;
    private RoomService _service;

    public RoomClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(RoomService.class);
    }

    @Override
    public void list(@Nullable String teamId, int max, @Nullable Room.RoomType type, @Nullable RoomClient.SortBy sortBy, @NonNull CompletionHandler<List<Room>> handler) {
        ServiceBuilder.async(this._authenticator, handler, RoomClientImpl$$Lambda$1.lambdaFactory$(this, teamId, type, sortBy, max, handler));
    }

    @Override
    public void create(@NonNull String title, @Nullable String teamId, @NonNull CompletionHandler<Room> handler) {
        ServiceBuilder.async(this._authenticator, handler, RoomClientImpl$$Lambda$2.lambdaFactory$(this, title, teamId, handler));
    }

    @Override
    public void get(@NonNull String roomId, @NonNull CompletionHandler<Room> handler) {
        ServiceBuilder.async(this._authenticator, handler, RoomClientImpl$$Lambda$3.lambdaFactory$(this, roomId, handler));
    }

    @Override
    public void update(@NonNull String roomId, @NonNull String title, @NonNull CompletionHandler<Room> handler) {
        ServiceBuilder.async(this._authenticator, handler, RoomClientImpl$$Lambda$4.lambdaFactory$(this, roomId, title, handler));
    }

    @Override
    public void delete(@NonNull String roomId, @NonNull CompletionHandler<Void> handler) {
        ServiceBuilder.async(this._authenticator, handler, RoomClientImpl$$Lambda$5.lambdaFactory$(this, roomId, handler));
    }

    static /* synthetic */ void lambda$delete$4(@NonNull RoomClientImpl this_, @NonNull String roomId, CompletionHandler handler, String s) {
        this_._service.delete(s, roomId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$update$3(@NonNull RoomClientImpl this_, @NonNull String roomId, @NonNull String title, CompletionHandler handler, String s) {
        this_._service.update(s, roomId, Maps.makeMap((Object)"title", (Object)title)).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$2(@NonNull RoomClientImpl this_, @NonNull String roomId, CompletionHandler handler, String s) {
        this_._service.get(s, roomId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$create$1(@NonNull RoomClientImpl this_, @Nullable String title, @NonNull String teamId, CompletionHandler handler, String s) {
        this_._service.create(s, Maps.makeMap((Object[])new Object[]{"title", title, "teamId", teamId})).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(@Nullable RoomClientImpl this_, @Nullable String teamId, @Nullable Room.RoomType type, RoomClient.SortBy sortBy, @NonNull int max, CompletionHandler handler, String s) {
        this_._service.list(s, teamId, type != null ? type.name() : null, sortBy != null ? sortBy.name().toLowerCase() : null, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface RoomService {
        @GET(value="rooms")
        public Call<ListBody<Room>> list(@Header(value="Authorization") String var1, @Query(value="teamId") String var2, @Query(value="type") String var3, @Query(value="sortBy") String var4, @Query(value="max") Integer var5);

        @POST(value="rooms")
        public Call<Room> create(@Header(value="Authorization") String var1, @Body Map var2);

        @GET(value="rooms/{roomId}")
        public Call<Room> get(@Header(value="Authorization") String var1, @Path(value="roomId") String var2);

        @PUT(value="rooms/{roomId}")
        public Call<Room> update(@Header(value="Authorization") String var1, @Path(value="roomId") String var2, @Body Map var3);

        @DELETE(value="rooms/{roomId}")
        public Call<Void> delete(@Header(value="Authorization") String var1, @Path(value="roomId") String var2);
    }
}

