/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.team.internal;

import android.support.annotation.NonNull;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.team.Team;
import com.ciscospark.androidsdk.team.TeamClient;
import com.ciscospark.androidsdk.team.internal.TeamClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.team.internal.TeamClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.team.internal.TeamClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.team.internal.TeamClientImpl$$Lambda$4;
import com.ciscospark.androidsdk.team.internal.TeamClientImpl$$Lambda$5;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.collection.Maps;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class TeamClientImpl
implements TeamClient {
    private Authenticator _authenticator;
    private TeamService _service;

    public TeamClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(TeamService.class);
    }

    @Override
    public void list(int max, @NonNull CompletionHandler<List<Team>> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamClientImpl$$Lambda$1.lambdaFactory$(this, max, handler));
    }

    @Override
    public void create(@NonNull String name, @NonNull CompletionHandler<Team> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamClientImpl$$Lambda$2.lambdaFactory$(this, name, handler));
    }

    @Override
    public void get(@NonNull String teamId, @NonNull CompletionHandler<Team> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamClientImpl$$Lambda$3.lambdaFactory$(this, teamId, handler));
    }

    @Override
    public void update(@NonNull String teamId, String name, @NonNull CompletionHandler<Team> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamClientImpl$$Lambda$4.lambdaFactory$(this, teamId, name, handler));
    }

    @Override
    public void delete(@NonNull String teamId, @NonNull CompletionHandler<Void> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamClientImpl$$Lambda$5.lambdaFactory$(this, teamId, handler));
    }

    static /* synthetic */ void lambda$delete$4(@NonNull TeamClientImpl this_, @NonNull String teamId, CompletionHandler handler, String s) {
        this_._service.delete(s, teamId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$update$3(@NonNull TeamClientImpl this_, String teamId, @NonNull String name, CompletionHandler handler, String s) {
        this_._service.update(s, teamId, Maps.makeMap((Object)"name", (Object)name)).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$2(@NonNull TeamClientImpl this_, @NonNull String teamId, CompletionHandler handler, String s) {
        this_._service.get(s, teamId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$create$1(@NonNull TeamClientImpl this_, @NonNull String name, CompletionHandler handler, String s) {
        this_._service.create(s, Maps.makeMap((Object)"name", (Object)name)).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(TeamClientImpl this_, @NonNull int max, CompletionHandler handler, String s) {
        this_._service.list(s, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface TeamService {
        @GET(value="teams")
        public Call<ListBody<Team>> list(@Header(value="Authorization") String var1, @Query(value="max") Integer var2);

        @POST(value="teams")
        public Call<Team> create(@Header(value="Authorization") String var1, @Body Map var2);

        @GET(value="teams/{teamId}")
        public Call<Team> get(@Header(value="Authorization") String var1, @Path(value="teamId") String var2);

        @PUT(value="teams/{teamId}")
        public Call<Team> update(@Header(value="Authorization") String var1, @Path(value="teamId") String var2, @Body Map var3);

        @DELETE(value="teams/{teamId}")
        public Call<Void> delete(@Header(value="Authorization") String var1, @Path(value="teamId") String var2);
    }
}

