/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.team.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.team.TeamMembership;
import com.ciscospark.androidsdk.team.TeamMembershipClient;
import com.ciscospark.androidsdk.team.internal.TeamMembershipClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.team.internal.TeamMembershipClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.team.internal.TeamMembershipClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.team.internal.TeamMembershipClientImpl$$Lambda$4;
import com.ciscospark.androidsdk.team.internal.TeamMembershipClientImpl$$Lambda$5;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.collection.Maps;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class TeamMembershipClientImpl
implements TeamMembershipClient {
    private Authenticator _authenticator;
    private TeamMembershipService _service;

    public TeamMembershipClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(TeamMembershipService.class);
    }

    @Override
    public void list(@Nullable String teamId, int max, @NonNull CompletionHandler<List<TeamMembership>> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamMembershipClientImpl$$Lambda$1.lambdaFactory$(this, teamId, max, handler));
    }

    @Override
    public void create(@NonNull String teamId, @Nullable String personId, @Nullable String personEmail, boolean isModerator, @NonNull CompletionHandler<TeamMembership> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamMembershipClientImpl$$Lambda$2.lambdaFactory$(this, teamId, personId, personEmail, isModerator, handler));
    }

    @Override
    public void get(@NonNull String membershipId, @NonNull CompletionHandler<TeamMembership> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamMembershipClientImpl$$Lambda$3.lambdaFactory$(this, membershipId, handler));
    }

    @Override
    public void update(@NonNull String membershipId, boolean isModerator, @NonNull CompletionHandler<TeamMembership> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamMembershipClientImpl$$Lambda$4.lambdaFactory$(this, membershipId, isModerator, handler));
    }

    @Override
    public void delete(@NonNull String membershipId, @NonNull CompletionHandler<Void> handler) {
        ServiceBuilder.async(this._authenticator, handler, TeamMembershipClientImpl$$Lambda$5.lambdaFactory$(this, membershipId, handler));
    }

    static /* synthetic */ void lambda$delete$4(@NonNull TeamMembershipClientImpl this_, @NonNull String membershipId, CompletionHandler handler, String s) {
        this_._service.delete(s, membershipId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$update$3(@NonNull TeamMembershipClientImpl this_, String membershipId, @NonNull boolean isModerator, CompletionHandler handler, String s) {
        this_._service.update(s, membershipId, Maps.makeMap((Object)"isModerator", (Object)isModerator)).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$2(@NonNull TeamMembershipClientImpl this_, @NonNull String membershipId, CompletionHandler handler, String s) {
        this_._service.get(s, membershipId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$create$1(@NonNull TeamMembershipClientImpl this_, @Nullable String teamId, @Nullable String personId, String personEmail, @NonNull boolean isModerator, CompletionHandler handler, String s) {
        this_._service.create(s, Maps.makeMap((Object[])new Object[]{"teamId", teamId, "personId", personId, "personEmail", personEmail, "isModerator", isModerator})).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(@Nullable TeamMembershipClientImpl this_, String teamId, @NonNull int max, CompletionHandler handler, String s) {
        this_._service.list(s, teamId, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface TeamMembershipService {
        @GET(value="team/memberships")
        public Call<ListBody<TeamMembership>> list(@Header(value="Authorization") String var1, @Query(value="teamId") String var2, @Query(value="max") Integer var3);

        @POST(value="team/memberships")
        public Call<TeamMembership> create(@Header(value="Authorization") String var1, @Body Map var2);

        @GET(value="team/memberships/{membershipId}")
        public Call<TeamMembership> get(@Header(value="Authorization") String var1, @Path(value="membershipId") String var2);

        @PUT(value="team/memberships/{membershipId}")
        public Call<TeamMembership> update(@Header(value="Authorization") String var1, @Path(value="membershipId") String var2, @Body Map var3);

        @DELETE(value="team/memberships/{membershipId}")
        public Call<Void> delete(@Header(value="Authorization") String var1, @Path(value="membershipId") String var2);
    }
}

