/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.utils.http;

import com.ciscospark.androidsdk.utils.http.ErrorHandlingAdapter$ErrorHandlingCallAdapter$1$$Lambda$1;
import com.ciscospark.androidsdk.utils.http.ErrorHandlingAdapter$ErrorHandlingCallAdapter$1$$Lambda$2;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ErrorHandlingAdapter {

    static class ErrorHandlingCallAdapter<T>
    implements ErrorHandlingCall<T> {
        private final Call<T> call;
        private final Executor callbackExecutor;

        ErrorHandlingCallAdapter(Call<T> call, Executor callbackExecutor) {
            this.call = call;
            this.callbackExecutor = callbackExecutor;
        }

        @Override
        public void cancel() {
            this.call.cancel();
        }

        @Override
        public void enqueue(final ErrorHandlingCallback<T> callback) {
            if (callback == null) {
                throw new NullPointerException("callback == null");
            }
            this.call.enqueue(new Callback<T>(){

                public void onResponse(Call<T> call, Response<T> response) {
                    ErrorHandlingCallAdapter.this.callbackExecutor.execute(ErrorHandlingAdapter$ErrorHandlingCallAdapter$1$$Lambda$1.lambdaFactory$(response, callback));
                }

                public void onFailure(Call<T> call, Throwable t) {
                    ErrorHandlingCallAdapter.this.callbackExecutor.execute(ErrorHandlingAdapter$ErrorHandlingCallAdapter$1$$Lambda$2.lambdaFactory$(t, callback));
                }

                static /* synthetic */ void lambda$onFailure$1(Throwable t, ErrorHandlingCallback callback2) {
                    if (t instanceof IOException) {
                        callback2.networkError((IOException)t);
                    } else {
                        callback2.unexpectedError(t);
                    }
                }

                static /* synthetic */ void lambda$onResponse$0(Response response, ErrorHandlingCallback callback2) {
                    int code = response.code();
                    if (code >= 200 && code < 300) {
                        callback2.success(response);
                    } else if (code == 401) {
                        callback2.unauthenticated(response);
                    } else if (code >= 400 && code < 500) {
                        callback2.clientError(response);
                    } else if (code >= 500 && code < 600) {
                        callback2.serverError(response);
                    } else {
                        callback2.unexpectedError(new RuntimeException("Unexpected response " + response));
                    }
                }
            });
        }

        @Override
        public ErrorHandlingCall<T> clone() {
            return new ErrorHandlingCallAdapter<T>(this.call.clone(), this.callbackExecutor);
        }
    }

    public static class ErrorHandlingCallAdapterFactory
    extends CallAdapter.Factory {
        public CallAdapter<ErrorHandlingCall<?>> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
            if (ErrorHandlingCallAdapterFactory.getRawType((Type)returnType) != ErrorHandlingCall.class) {
                return null;
            }
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalStateException("ErrorHandlingCall must have generic type (e.g., ErrorHandlingCall<ResponseBody>)");
            }
            final Type responseType = ErrorHandlingCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
            Executor retrofitExecutor = retrofit.callbackExecutor();
            final Executor callbackExecutor = retrofitExecutor == null ? new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            } : retrofitExecutor;
            return new CallAdapter<ErrorHandlingCall<?>>(){

                public Type responseType() {
                    return responseType;
                }

                public <R> ErrorHandlingCall<R> adapt(Call<R> call) {
                    return new ErrorHandlingCallAdapter<R>(call, callbackExecutor);
                }
            };
        }
    }

    public static interface ErrorHandlingCall<T> {
        public void cancel();

        public void enqueue(ErrorHandlingCallback<T> var1);

        public ErrorHandlingCall<T> clone();
    }

    public static interface ErrorHandlingCallback<T> {
        public void success(Response<T> var1);

        public void unauthenticated(Response<?> var1);

        public void clientError(Response<?> var1);

        public void serverError(Response<?> var1);

        public void networkError(IOException var1);

        public void unexpectedError(Throwable var1);
    }
}

