/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.utils.http;

import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.Result;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.internal.ResultImpl;
import com.ciscospark.androidsdk.utils.http.DefaultHeadersInterceptor;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ServiceBuilder {
    public static final String HYDRA_URL = "https://api.ciscospark.com/v1/";
    private String _baseURL = "https://api.ciscospark.com/v1/";
    private Gson _gson;
    private List<Interceptor> _interceptors = new ArrayList<Interceptor>(1);
    private boolean _interceptorChanged = false;

    public ServiceBuilder() {
        this._interceptors.add(new DefaultHeadersInterceptor());
    }

    public ServiceBuilder baseURL(String url) {
        this._baseURL = url;
        return this;
    }

    public ServiceBuilder gson(Gson gson) {
        this._gson = gson;
        return this;
    }

    public ServiceBuilder interceptor(Interceptor interceptor) {
        if (!this._interceptorChanged) {
            this._interceptors.clear();
            this._interceptorChanged = true;
        }
        if (interceptor != null) {
            this._interceptors.add(interceptor);
        }
        return this;
    }

    public <T> T build(Class<T> service) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        for (Interceptor interceptor : this._interceptors) {
            httpClient.addInterceptor(interceptor);
        }
        OkHttpClient client = httpClient.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this._baseURL).addConverterFactory((Converter.Factory)(this._gson == null ? GsonConverterFactory.create() : GsonConverterFactory.create((Gson)this._gson))).client(client).build();
        return (T)retrofit.create(service);
    }

    public static <T> void async(Authenticator authenticator, final CompletionHandler<T> handler, final Closure<String> closure) {
        authenticator.getToken(new CompletionHandler<String>(){

            @Override
            public void onComplete(Result<String> result) {
                String token = result.getData();
                if (token != null) {
                    closure.invoke("Bearer " + token);
                } else if (handler != null) {
                    handler.onComplete(ResultImpl.error(result.getError()));
                }
            }
        });
    }

    public static interface Closure<P> {
        public void invoke(P var1);
    }
}

