/*
 * Decompiled with CFR 0.152.
 */
package com.ciscospark.androidsdk.webhook.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ciscospark.androidsdk.CompletionHandler;
import com.ciscospark.androidsdk.auth.Authenticator;
import com.ciscospark.androidsdk.utils.http.ListBody;
import com.ciscospark.androidsdk.utils.http.ListCallback;
import com.ciscospark.androidsdk.utils.http.ObjectCallback;
import com.ciscospark.androidsdk.utils.http.ServiceBuilder;
import com.ciscospark.androidsdk.webhook.Webhook;
import com.ciscospark.androidsdk.webhook.WebhookClient;
import com.ciscospark.androidsdk.webhook.internal.WebhookClientImpl$$Lambda$1;
import com.ciscospark.androidsdk.webhook.internal.WebhookClientImpl$$Lambda$2;
import com.ciscospark.androidsdk.webhook.internal.WebhookClientImpl$$Lambda$3;
import com.ciscospark.androidsdk.webhook.internal.WebhookClientImpl$$Lambda$4;
import com.ciscospark.androidsdk.webhook.internal.WebhookClientImpl$$Lambda$5;
import java.util.List;
import java.util.Map;
import me.helloworld.utils.collection.Maps;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class WebhookClientImpl
implements WebhookClient {
    private Authenticator _authenticator;
    private WebhookService _service;

    public WebhookClientImpl(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._service = new ServiceBuilder().build(WebhookService.class);
    }

    @Override
    public void list(int max, @NonNull CompletionHandler<List<Webhook>> handler) {
        ServiceBuilder.async(this._authenticator, handler, WebhookClientImpl$$Lambda$1.lambdaFactory$(this, max, handler));
    }

    @Override
    public void create(@NonNull String name, @NonNull String targetUrl, @NonNull String resource, @NonNull String event, @Nullable String filter, @Nullable String secret, @NonNull CompletionHandler<Webhook> handler) {
        ServiceBuilder.async(this._authenticator, handler, WebhookClientImpl$$Lambda$2.lambdaFactory$(this, name, targetUrl, filter, secret, resource, event, handler));
    }

    @Override
    public void get(@NonNull String webhookId, @NonNull CompletionHandler<Webhook> handler) {
        ServiceBuilder.async(this._authenticator, handler, WebhookClientImpl$$Lambda$3.lambdaFactory$(this, webhookId, handler));
    }

    @Override
    public void update(@NonNull String webhookId, @NonNull String name, @NonNull String targetUrl, @NonNull CompletionHandler<Webhook> handler) {
        ServiceBuilder.async(this._authenticator, handler, WebhookClientImpl$$Lambda$4.lambdaFactory$(this, webhookId, name, targetUrl, handler));
    }

    @Override
    public void delete(@NonNull String webhookId, @NonNull CompletionHandler<Void> handler) {
        ServiceBuilder.async(this._authenticator, handler, WebhookClientImpl$$Lambda$5.lambdaFactory$(this, webhookId, handler));
    }

    static /* synthetic */ void lambda$delete$4(@NonNull WebhookClientImpl this_, @NonNull String webhookId, CompletionHandler handler, String s) {
        this_._service.delete(s, webhookId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$update$3(@NonNull WebhookClientImpl this_, @NonNull String webhookId, @NonNull String name, @NonNull String targetUrl, CompletionHandler handler, String s) {
        this_._service.update(s, webhookId, Maps.makeMap((Object[])new Object[]{"name", name, "targetUrl", targetUrl})).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$get$2(@NonNull WebhookClientImpl this_, @NonNull String webhookId, CompletionHandler handler, String s) {
        this_._service.get(s, webhookId).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$create$1(@NonNull WebhookClientImpl this_, @NonNull String name, @Nullable String targetUrl, @Nullable String filter, @NonNull String secret, @NonNull String resource, @NonNull String event, CompletionHandler handler, String s) {
        this_._service.create(s, Maps.makeMap((Object[])new Object[]{"name", name, "targetUrl", targetUrl, "filter", filter, "secret", secret, "resource", resource, "event", event})).enqueue(new ObjectCallback(handler));
    }

    static /* synthetic */ void lambda$list$0(WebhookClientImpl this_, @NonNull int max, CompletionHandler handler, String s) {
        this_._service.list(s, max <= 0 ? null : Integer.valueOf(max)).enqueue(new ListCallback(handler));
    }

    private static interface WebhookService {
        @GET(value="webhooks")
        public Call<ListBody<Webhook>> list(@Header(value="Authorization") String var1, @Query(value="max") Integer var2);

        @POST(value="webhooks")
        public Call<Webhook> create(@Header(value="Authorization") String var1, @Body Map var2);

        @GET(value="webhooks/{webhookId}")
        public Call<Webhook> get(@Header(value="Authorization") String var1, @Path(value="webhookId") String var2);

        @PUT(value="webhooks/{webhookId}")
        public Call<Webhook> update(@Header(value="Authorization") String var1, @Path(value="webhookId") String var2, @Body Map var3);

        @DELETE(value="webhooks/{webhookId}")
        public Call<Void> delete(@Header(value="Authorization") String var1, @Path(value="webhookId") String var2);
    }
}

