/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.abi;

import com.citahub.cita.abi.TypeReference;
import com.citahub.cita.abi.Utils;
import com.citahub.cita.abi.datatypes.Event;
import com.citahub.cita.abi.datatypes.Type;
import com.citahub.cita.abi.datatypes.UnorderedEvent;
import com.citahub.cita.crypto.Hash;
import com.citahub.cita.utils.Numeric;
import java.util.ArrayList;
import java.util.List;

public class EventEncoder {
    private EventEncoder() {
    }

    public static String encode(Event function) {
        List indexedParameters = function.getIndexedParameters();
        List nonIndexedParameters = function.getNonIndexedParameters();
        String methodSignature = EventEncoder.buildMethodSignature(function.getName(), indexedParameters, nonIndexedParameters);
        return EventEncoder.buildEventSignature(methodSignature);
    }

    public static String encode(UnorderedEvent event) {
        List parameters = event.getParameters();
        String methodSignature = EventEncoder.buildMethodSignature(event.getName(), parameters);
        return EventEncoder.buildEventSignature(methodSignature);
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> indexParameters) {
        ArrayList<TypeReference<T>> parameters = new ArrayList<TypeReference<T>>(indexParameters);
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            params.append(Utils.getTypeName((TypeReference)parameters.get(i)));
            if (i + 1 >= parameters.size()) continue;
            params.append(",");
        }
        result.append(params.toString());
        result.append(")");
        return result.toString();
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> indexParameters, List<TypeReference<T>> nonIndexedParameters) {
        ArrayList<TypeReference<T>> parameters = new ArrayList<TypeReference<T>>(indexParameters);
        parameters.addAll(nonIndexedParameters);
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            params.append(Utils.getTypeName((TypeReference)parameters.get(i)));
            if (i + 1 >= parameters.size()) continue;
            params.append(",");
        }
        result.append(params.toString());
        result.append(")");
        return result.toString();
    }

    public static String buildEventSignature(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash);
    }
}

