/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.abi;

import com.citahub.cita.abi.datatypes.Address;
import com.citahub.cita.abi.datatypes.Array;
import com.citahub.cita.abi.datatypes.Bool;
import com.citahub.cita.abi.datatypes.Bytes;
import com.citahub.cita.abi.datatypes.BytesType;
import com.citahub.cita.abi.datatypes.DynamicArray;
import com.citahub.cita.abi.datatypes.DynamicBytes;
import com.citahub.cita.abi.datatypes.NumericType;
import com.citahub.cita.abi.datatypes.StaticArray;
import com.citahub.cita.abi.datatypes.Type;
import com.citahub.cita.abi.datatypes.Ufixed;
import com.citahub.cita.abi.datatypes.Uint;
import com.citahub.cita.abi.datatypes.Utf8String;
import com.citahub.cita.utils.Numeric;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class TypeEncoder {
    private TypeEncoder() {
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray;
    }

    public static String encode(Type parameter) {
        if (parameter instanceof NumericType) {
            return TypeEncoder.encodeNumeric((NumericType)parameter);
        }
        if (parameter instanceof Address) {
            return TypeEncoder.encodeAddress((Address)parameter);
        }
        if (parameter instanceof Bool) {
            return TypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return TypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return TypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return TypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof StaticArray) {
            return TypeEncoder.encodeArrayValues((StaticArray)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    static String encodeAddress(Address address) {
        return TypeEncoder.encodeNumeric(address.toUint160());
    }

    static String encodeNumeric(NumericType numericType) {
        byte[] rawValue = TypeEncoder.toByteArray(numericType);
        byte paddingValue = TypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix((byte[])paddedRawValue);
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return Numeric.toHexStringNoPrefix((byte[])rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return Numeric.toHexStringNoPrefix((byte[])dest);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValue = TypeEncoder.encodeBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return TypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(Array<T> value) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            result.append(TypeEncoder.encode(type));
        }
        return result.toString();
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValues = TypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValues);
        return result.toString();
    }
}

