/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.abi;

import com.citahub.cita.abi.datatypes.Type;
import java.lang.reflect.ParameterizedType;

public abstract class TypeReference<T extends Type>
implements Comparable<TypeReference<T>> {
    private final java.lang.reflect.Type type;

    protected TypeReference() {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return 0;
    }

    public java.lang.reflect.Type getType() {
        return this.type;
    }

    public Class<T> getClassType() throws ClassNotFoundException {
        java.lang.reflect.Type clsType = this.getType();
        if (this.getType() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)clsType).getRawType();
        }
        return Class.forName(((Class)clsType).getName());
    }

    public static <T extends Type> TypeReference<T> create(final Class<T> cls) {
        return new TypeReference<T>(){

            @Override
            public java.lang.reflect.Type getType() {
                return cls;
            }
        };
    }

    public static <T extends Type> TypeReference<T> create(final ParameterizedType type) {
        return new TypeReference<T>(){

            @Override
            public java.lang.reflect.Type getType() {
                return type;
            }
        };
    }

    public static <T extends Type> StaticArrayTypeReference<T> create(int length, final ParameterizedType type) {
        return new StaticArrayTypeReference<T>(length){

            @Override
            public java.lang.reflect.Type getType() {
                return type;
            }
        };
    }

    public static abstract class StaticArrayTypeReference<T extends Type>
    extends TypeReference<T> {
        private final int size;

        protected StaticArrayTypeReference(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

