/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.abi;

import com.citahub.cita.abi.TypeMappingException;
import com.citahub.cita.abi.TypeReference;
import com.citahub.cita.abi.datatypes.DynamicArray;
import com.citahub.cita.abi.datatypes.DynamicBytes;
import com.citahub.cita.abi.datatypes.Fixed;
import com.citahub.cita.abi.datatypes.Int;
import com.citahub.cita.abi.datatypes.StaticArray;
import com.citahub.cita.abi.datatypes.Type;
import com.citahub.cita.abi.datatypes.Ufixed;
import com.citahub.cita.abi.datatypes.Uint;
import com.citahub.cita.abi.datatypes.Utf8String;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    private Utils() {
    }

    static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        try {
            java.lang.reflect.Type reflectedType = typeReference.getType();
            if (reflectedType instanceof ParameterizedType) {
                Class type = (Class)((ParameterizedType)reflectedType).getRawType();
                return Utils.getParameterizedTypeName(typeReference, type);
            }
            Class<?> type = Class.forName(reflectedType.getTypeName());
            return Utils.getSimpleTypeName(type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static String getSimpleTypeName(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        return simpleName;
    }

    static <T extends Type, U extends Type> String getParameterizedTypeName(TypeReference<T> typeReference, Class<?> type) {
        try {
            if (type.equals(DynamicArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[]";
            }
            if (StaticArray.class.isAssignableFrom(type)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[" + ((TypeReference.StaticArrayTypeReference)typeReference).getSize() + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static <T extends Type> Class<T> getParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        java.lang.reflect.Type type = typeReference.getType();
        java.lang.reflect.Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        String parameterizedTypeName = typeArguments[0].getTypeName();
        return Class.forName(parameterizedTypeName);
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        for (TypeReference<?> typeReference : input) {
            result.add(typeReference);
        }
        return result;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<R> result = new ArrayList<R>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }
}

