/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.abi.datatypes;

import com.citahub.cita.abi.datatypes.Type;
import com.citahub.cita.abi.datatypes.generated.Uint160;
import com.citahub.cita.utils.Numeric;
import java.math.BigInteger;

public class Address
implements Type<String> {
    public static final String TYPE_NAME = "address";
    public static final int LENGTH = 160;
    public static final int LENGTH_IN_HEX = 40;
    public static final Address DEFAULT = new Address(BigInteger.ZERO);
    private final Uint160 value;

    public Address(Uint160 value) {
        this.value = value;
    }

    public Address(BigInteger value) {
        this(new Uint160(value));
    }

    public Address(String hexValue) {
        this(Numeric.toBigInt((String)hexValue));
    }

    public Uint160 toUint160() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_NAME;
    }

    public String toString() {
        return Numeric.toHexStringWithPrefixZeroPadded((BigInteger)this.value.getValue(), (int)40);
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.value != null ? this.value.equals(address.value) : address.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

