/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.abi.datatypes;

import com.citahub.cita.abi.TypeReference;
import com.citahub.cita.abi.datatypes.Type;
import java.util.ArrayList;
import java.util.List;

public class UnorderedEvent {
    private String name;
    private List<EventType> params;

    public UnorderedEvent(String name) {
        this.name = name;
        this.params = new ArrayList<EventType>();
    }

    public void add(boolean indexed, TypeReference type) {
        EventType eventType = new EventType();
        eventType.indexed = indexed;
        eventType.type = type;
        eventType.seqNum = this.params.size();
        this.params.add(eventType);
    }

    public String getName() {
        return this.name;
    }

    public List<TypeReference<Type>> getParameters() {
        ArrayList<TypeReference<Type>> list = new ArrayList<TypeReference<Type>>();
        for (EventType eventType : this.params) {
            list.add(eventType.type);
        }
        return list;
    }

    public List<TypeReference<Type>> getIndexedParameters() {
        ArrayList<TypeReference<Type>> list = new ArrayList<TypeReference<Type>>();
        for (EventType eventType : this.params) {
            if (!eventType.indexed) continue;
            list.add(eventType.type);
        }
        return list;
    }

    public List<Integer> getIndexedParametersSeq() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (EventType eventType : this.params) {
            if (!eventType.indexed) continue;
            list.add(eventType.seqNum);
        }
        return list;
    }

    public List<TypeReference<Type>> getNonIndexedParameters() {
        ArrayList<TypeReference<Type>> list = new ArrayList<TypeReference<Type>>();
        for (EventType eventType : this.params) {
            if (eventType.indexed) continue;
            list.add(eventType.type);
        }
        return list;
    }

    public List<Integer> getNonIndexedParametersSeq() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (EventType eventType : this.params) {
            if (eventType.indexed) continue;
            list.add(eventType.seqNum);
        }
        return list;
    }

    private class EventType {
        public boolean indexed;
        public TypeReference<Type> type;
        public int seqNum;

        private EventType() {
        }
    }
}

