/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.crypto;

import com.citahub.cita.crypto.Hash;
import com.citahub.cita.rlp.RlpEncoder;
import com.citahub.cita.rlp.RlpList;
import com.citahub.cita.rlp.RlpString;
import com.citahub.cita.rlp.RlpType;
import com.citahub.cita.utils.Numeric;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class ContractUtils {
    public static byte[] generateContractAddress(byte[] address, BigInteger nonce) {
        ArrayList<RlpString> values = new ArrayList<RlpString>();
        values.add(RlpString.create((byte[])address));
        values.add(RlpString.create((BigInteger)nonce));
        RlpList rlpList = new RlpList(values);
        byte[] encoded = RlpEncoder.encode((RlpType)rlpList);
        byte[] hashed = Hash.sha3((byte[])encoded);
        return Arrays.copyOfRange(hashed, 12, hashed.length);
    }

    public static String generateContractAddress(String address, BigInteger nonce) {
        byte[] result = ContractUtils.generateContractAddress(Numeric.hexStringToByteArray((String)address), nonce);
        return Numeric.toHexString((byte[])result);
    }
}

