/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.crypto;

import com.citahub.cita.crypto.Sign;
import java.math.BigInteger;

public class ECDSASignature {
    public final BigInteger r;
    public final BigInteger s;

    public ECDSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public boolean isCanonical() {
        return this.s.compareTo(Sign.HALF_CURVE_ORDER) <= 0;
    }

    public ECDSASignature toCanonicalised() {
        if (!this.isCanonical()) {
            return new ECDSASignature(this.r, Sign.CURVE.getN().subtract(this.s));
        }
        return this;
    }
}

