/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.crypto;

import com.citahub.cita.crypto.Credentials;
import com.citahub.cita.crypto.Hash;
import com.citahub.cita.crypto.RawTransaction;
import com.citahub.cita.crypto.TransactionEncoder;
import com.citahub.cita.utils.Numeric;

public class TransactionUtils {
    public static byte[] generateTransactionHash(RawTransaction rawTransaction, Credentials credentials) {
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, credentials);
        return Hash.sha3((byte[])signedMessage);
    }

    public static byte[] generateTransactionHash(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, chainId, credentials);
        return Hash.sha3((byte[])signedMessage);
    }

    public static String generateTransactionHashHexEncoded(RawTransaction rawTransaction, Credentials credentials) {
        return Numeric.toHexString((byte[])TransactionUtils.generateTransactionHash(rawTransaction, credentials));
    }

    public static String generateTransactionHashHexEncoded(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        return Numeric.toHexString((byte[])TransactionUtils.generateTransactionHash(rawTransaction, chainId, credentials));
    }
}

