/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.crypto.sm2;

import com.citahub.cita.crypto.sm2.SM2KeyPair;
import com.citahub.cita.crypto.sm2.SM3;
import com.citahub.cita.utils.HexUtil;
import com.citahub.cita.utils.Numeric;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    private static BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static ECDomainParameters ecc_bc_spec;
    private static int w;
    private static BigInteger _2w;
    private static final int DIGEST_LENGTH = 32;
    private static SecureRandom random;
    private static ECCurve.Fp curve;
    private static ECPoint G;
    private boolean debug = false;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void printHexString(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            System.out.print(hex.toUpperCase());
        }
        System.out.println();
    }

    private static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    public byte[] encrypt(String input, ECPoint publicKey) {
        byte[] c1Buffer;
        BigInteger k;
        ECPoint kpb;
        byte[] kpbBytes;
        byte[] t;
        byte[] inputBuffer = input.getBytes();
        if (this.debug) {
            SM2.printHexString(inputBuffer);
        }
        do {
            ECPoint s;
            BigInteger h;
            k = SM2.random(n);
            if (this.debug) {
                System.out.print("k: ");
                SM2.printHexString(k.toByteArray());
            }
            ECPoint c1 = G.multiply(k);
            c1Buffer = c1.getEncoded(false);
            if (this.debug) {
                System.out.print("C1: ");
                SM2.printHexString(c1Buffer);
            }
            if ((h = ecc_bc_spec.getH()) == null || !(s = publicKey.multiply(h)).isInfinity()) continue;
            throw new IllegalStateException();
        } while (this.allZero(t = SM2.kdf(kpbBytes = (kpb = publicKey.multiply(k).normalize()).getEncoded(false), inputBuffer.length)));
        byte[] c2 = new byte[inputBuffer.length];
        for (int i = 0; i < inputBuffer.length; ++i) {
            c2[i] = (byte)(inputBuffer[i] ^ t[i]);
        }
        byte[] c3 = SM2.sm3hash(kpb.getXCoord().toBigInteger().toByteArray(), inputBuffer, kpb.getYCoord().toBigInteger().toByteArray());
        byte[] encryptResult = new byte[c1Buffer.length + c2.length + c3.length];
        System.arraycopy(c1Buffer, 0, encryptResult, 0, c1Buffer.length);
        System.arraycopy(c2, 0, encryptResult, c1Buffer.length, c2.length);
        System.arraycopy(c3, 0, encryptResult, c1Buffer.length + c2.length, c3.length);
        if (this.debug) {
            System.out.print("\u5bc6\u6587: ");
            SM2.printHexString(encryptResult);
        }
        return encryptResult;
    }

    public String decrypt(byte[] encryptData, BigInteger privateKey) {
        int klen;
        ECPoint s;
        if (this.debug) {
            System.out.println("encryptData length: " + encryptData.length);
        }
        byte[] c1Byte = new byte[65];
        System.arraycopy(encryptData, 0, c1Byte, 0, c1Byte.length);
        ECPoint c1 = curve.decodePoint(c1Byte).normalize();
        BigInteger h = ecc_bc_spec.getH();
        if (h != null && (s = c1.multiply(h)).isInfinity()) {
            throw new IllegalStateException();
        }
        ECPoint dBC1 = c1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        byte[] t = SM2.kdf(dBC1Bytes, klen = encryptData.length - 65 - 32);
        if (this.allZero(t)) {
            System.err.println("all zero");
            throw new IllegalStateException();
        }
        byte[] m = new byte[klen];
        for (int i = 0; i < m.length; ++i) {
            m[i] = (byte)(encryptData[c1Byte.length + i] ^ t[i]);
        }
        if (this.debug) {
            SM2.printHexString(m);
        }
        byte[] c3 = new byte[32];
        if (this.debug) {
            try {
                System.out.println("M = " + new String(m, "UTF8"));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        System.arraycopy(encryptData, encryptData.length - 32, c3, 0, 32);
        byte[] u = SM2.sm3hash(dBC1.getXCoord().toBigInteger().toByteArray(), m, dBC1.getYCoord().toBigInteger().toByteArray());
        if (Arrays.equals(u, c3)) {
            if (this.debug) {
                System.out.println("\u89e3\u5bc6\u6210\u529f");
            }
            try {
                return new String(m, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.debug) {
            System.out.print("u = ");
            SM2.printHexString(u);
            System.out.print("C3 = ");
            SM2.printHexString(c3);
            System.err.println("\u89e3\u5bc6\u9a8c\u8bc1\u5931\u8d25");
        }
        return null;
    }

    private boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (this.between(x, new BigInteger("0"), p) && this.between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                if (this.debug) {
                    System.out.println("xResult: " + xResult.toString());
                }
                BigInteger yResult = y.pow(2).mod(p);
                if (this.debug) {
                    System.out.println("yResult: " + yResult.toString());
                }
                if (yResult.equals(xResult) && publicKey.multiply(n).isInfinity()) {
                    return true;
                }
            }
        }
        return false;
    }

    public SM2KeyPair fromPrivateKey(String privateKey) {
        BigInteger pk = Numeric.toBigInt((String)privateKey);
        SM2KeyPair keyPair = new SM2KeyPair(G.multiply(pk).normalize(), pk);
        if (this.checkPublicKey(keyPair.getPublicKey())) {
            if (this.debug) {
                System.out.println("generate key successfully");
            }
            return keyPair;
        }
        if (this.debug) {
            System.err.println("generate key failed");
        }
        return null;
    }

    public SM2KeyPair generateKeyPair() {
        BigInteger d = SM2.random(n.subtract(new BigInteger("1")));
        SM2KeyPair keyPair = new SM2KeyPair(G.multiply(d).normalize(), d);
        if (this.checkPublicKey(keyPair.getPublicKey())) {
            if (this.debug) {
                System.out.println("generate key successfully");
            }
            return keyPair;
        }
        if (this.debug) {
            System.err.println("generate key failed");
        }
        return null;
    }

    public SM2() {
        curve = new ECCurve.Fp(p, a, b);
        G = curve.createPoint(gx, gy);
        ecc_bc_spec = new ECDomainParameters((ECCurve)curve, G, n);
    }

    public SM2(boolean debug) {
        this();
        this.debug = debug;
    }

    public void exportPublicKey(ECPoint publicKey, String path) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] buffer = publicKey.getEncoded(false);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buffer);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ECPoint importPublicKey(String path) {
        File file = new File(path);
        try {
            int size;
            if (!file.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[16];
            while ((size = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, size);
            }
            fis.close();
            return curve.decodePoint(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ECPoint toPublicKey(byte[] publickey) {
        return curve.decodePoint(publickey);
    }

    public void exportPrivateKey(BigInteger privateKey, String path) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(privateKey);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BigInteger importPrivateKey(String path) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            BigInteger res = (BigInteger)ois.readObject();
            ois.close();
            fis.close();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (int i = 0; i < params.length; ++i) {
                baos.write(params[i]);
            }
            res = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] sm3hash(byte[] ... params) {
        byte[] res = null;
        try {
            res = SM3.hash(SM2.join(params));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] za(String ida, ECPoint aPublicKey) {
        byte[] idaBytes = ida.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] entla = new byte[]{(byte)(entlenA & 0xFF00), (byte)(entlenA & 0xFF)};
        byte[] za = SM2.sm3hash(entla, idaBytes, SM2.getBytesFromBigInteger(a), SM2.getBytesFromBigInteger(b), SM2.getBytesFromBigInteger(gx), SM2.getBytesFromBigInteger(gy), Signature.fillBytes32(SM2.getBytesFromBigInteger(aPublicKey.getXCoord().toBigInteger())), Signature.fillBytes32(SM2.getBytesFromBigInteger(aPublicKey.getYCoord().toBigInteger())));
        return za;
    }

    private static byte[] getBytesFromBigInteger(BigInteger value) {
        byte[] array = value.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return array;
    }

    public Signature sign(byte[] data, String ida, SM2KeyPair keyPair) {
        BigInteger k;
        BigInteger r;
        byte[] za = SM2.za(ida, keyPair.getPublicKey());
        byte[] m = SM2.join(za, data);
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{m}));
        do {
            k = SM2.random(n);
            ECPoint p1 = G.multiply(k).normalize();
            BigInteger x1 = p1.getXCoord().toBigInteger();
            r = e.add(x1);
        } while ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n));
        BigInteger s = keyPair.getPrivateKey().add(BigInteger.ONE).modInverse(n).multiply(k.subtract(r.multiply(keyPair.getPrivateKey())).mod(n)).mod(n);
        return new Signature(r, s);
    }

    public boolean verify(byte[] data, Signature signature, String ida, ECPoint aPublicKey) {
        ECPoint p2;
        if (!this.between(signature.r, BigInteger.ONE, n)) {
            return false;
        }
        if (!this.between(signature.s, BigInteger.ONE, n)) {
            return false;
        }
        byte[] m = SM2.join(SM2.za(ida, aPublicKey), data);
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{m}));
        BigInteger t = signature.r.add(signature.s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = G.multiply(signature.s).normalize();
        BigInteger x1 = p1.add(p2 = aPublicKey.multiply(t).normalize()).normalize().getXCoord().toBigInteger();
        BigInteger r = e.add(x1).mod(n);
        return r.equals(signature.r);
    }

    private static byte[] kdf(byte[] z, int klen) {
        int ct = 1;
        int end = (int)Math.ceil((double)klen * 1.0 / 32.0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (int i = 1; i < end; ++i) {
                baos.write(SM2.sm3hash(z, SM3.toByteArray(ct)));
                ++ct;
            }
            byte[] last = SM2.sm3hash(z, SM3.toByteArray(ct));
            if (klen % 32 == 0) {
                baos.write(last);
            } else {
                baos.write(last, 0, klen % 32);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getSignature(Signature signature, ECPoint publicKey) {
        String publicKeyBytes = Signature.fillStr64(publicKey.getRawXCoord().toString()) + Signature.fillStr64(publicKey.getRawYCoord().toString());
        return SM2.join(HexUtil.hexToBytes((String)signature.getSign()), HexUtil.hexToBytes((String)publicKeyBytes));
    }

    static {
        w = (int)Math.ceil((double)n.bitLength() * 1.0 / 2.0) - 1;
        _2w = new BigInteger("2").pow(w);
        random = new SecureRandom();
    }

    public static class Signature {
        BigInteger r;
        BigInteger s;

        public Signature(BigInteger r, BigInteger s) {
            this.r = r;
            this.s = s;
        }

        public String toString() {
            return "r: " + this.r.toString(16) + ",s: " + this.s.toString(16);
        }

        public String getSign() {
            return Signature.fillStr64(this.r.toString(16)) + Signature.fillStr64(this.s.toString(16));
        }

        static String fillStr64(String str) {
            if (str.length() >= 64) {
                return str;
            }
            int len = 64 - str.length();
            StringBuffer sb = new StringBuffer(str);
            for (int i = 0; i < len; ++i) {
                sb.insert(0, "0");
            }
            return sb.toString();
        }

        static byte[] fillBytes32(byte[] bytes) {
            if (bytes.length >= 32) {
                return bytes;
            }
            byte[] res = new byte[32];
            int index = 32 - bytes.length;
            System.arraycopy(bytes, 0, res, index, bytes.length);
            return res;
        }
    }

    public static class KeyExchange {
        BigInteger rA;
        ECPoint ra;
        ECPoint v;
        byte[] z;
        byte[] key;
        String id;
        SM2KeyPair keyPair;

        public KeyExchange(String id, SM2KeyPair keyPair) {
            this.id = id;
            this.keyPair = keyPair;
            this.z = SM2.za(id, keyPair.getPublicKey());
        }

        public TransportEntity keyExchange_1() {
            this.rA = SM2.random(n);
            this.ra = G.multiply(this.rA).normalize();
            return new TransportEntity(this.ra.getEncoded(false), null, this.z, this.keyPair.getPublicKey());
        }

        public TransportEntity keyExchange_2(TransportEntity entity) {
            BigInteger rB = SM2.random(n);
            ECPoint rb = G.multiply(rB).normalize();
            this.rA = rB;
            this.ra = rb;
            BigInteger x2 = rb.getXCoord().toBigInteger();
            x2 = _2w.add(x2.and(_2w.subtract(BigInteger.ONE)));
            BigInteger tB = this.keyPair.getPrivateKey().add(x2.multiply(rB)).mod(n);
            ECPoint RA = curve.decodePoint(entity.r).normalize();
            BigInteger x1 = RA.getXCoord().toBigInteger();
            x1 = _2w.add(x1.and(_2w.subtract(BigInteger.ONE)));
            ECPoint aPublicKey = curve.decodePoint(entity.k).normalize();
            ECPoint temp = aPublicKey.add(RA.multiply(x1).normalize()).normalize();
            ECPoint v = temp.multiply(ecc_bc_spec.getH().multiply(tB)).normalize();
            if (v.isInfinity()) {
                throw new IllegalStateException();
            }
            this.v = v;
            byte[] xV = v.getXCoord().toBigInteger().toByteArray();
            byte[] yV = v.getYCoord().toBigInteger().toByteArray();
            byte[] kb = SM2.kdf(SM2.join(new byte[][]{xV, yV, entity.z, this.z}), 16);
            this.key = kb;
            System.out.print("\u534f\u5546\u5f97B\u5bc6\u94a5:");
            SM2.printHexString(kb);
            byte[] sB = SM2.sm3hash(new byte[][]{{2}, yV, SM2.sm3hash(new byte[][]{xV, entity.z, this.z, RA.getXCoord().toBigInteger().toByteArray(), RA.getYCoord().toBigInteger().toByteArray(), rb.getXCoord().toBigInteger().toByteArray(), rb.getYCoord().toBigInteger().toByteArray()})});
            return new TransportEntity(rb.getEncoded(false), sB, this.z, this.keyPair.getPublicKey());
        }

        public TransportEntity keyExchange_3(TransportEntity entity) {
            BigInteger x1 = this.ra.getXCoord().toBigInteger();
            x1 = _2w.add(x1.and(_2w.subtract(BigInteger.ONE)));
            BigInteger tA = this.keyPair.getPrivateKey().add(x1.multiply(this.rA)).mod(n);
            ECPoint RB = curve.decodePoint(entity.r).normalize();
            BigInteger x2 = RB.getXCoord().toBigInteger();
            x2 = _2w.add(x2.and(_2w.subtract(BigInteger.ONE)));
            ECPoint bPublicKey = curve.decodePoint(entity.k).normalize();
            ECPoint temp = bPublicKey.add(RB.multiply(x2).normalize()).normalize();
            ECPoint u = temp.multiply(ecc_bc_spec.getH().multiply(tA)).normalize();
            if (u.isInfinity()) {
                throw new IllegalStateException();
            }
            this.v = u;
            byte[] xU = u.getXCoord().toBigInteger().toByteArray();
            byte[] yU = u.getYCoord().toBigInteger().toByteArray();
            byte[] ka = SM2.kdf(SM2.join(new byte[][]{xU, yU, this.z, entity.z}), 16);
            this.key = ka;
            System.out.print("\u534f\u5546\u5f97A\u5bc6\u94a5:");
            SM2.printHexString(ka);
            byte[] s1 = SM2.sm3hash(new byte[][]{{2}, yU, SM2.sm3hash(new byte[][]{xU, this.z, entity.z, this.ra.getXCoord().toBigInteger().toByteArray(), this.ra.getYCoord().toBigInteger().toByteArray(), RB.getXCoord().toBigInteger().toByteArray(), RB.getYCoord().toBigInteger().toByteArray()})});
            if (Arrays.equals(entity.s, s1)) {
                System.out.println("B->A \u5bc6\u94a5\u786e\u8ba4\u6210\u529f");
            } else {
                System.out.println("B->A \u5bc6\u94a5\u786e\u8ba4\u5931\u8d25");
            }
            byte[] sA = SM2.sm3hash(new byte[][]{{3}, yU, SM2.sm3hash(new byte[][]{xU, this.z, entity.z, this.ra.getXCoord().toBigInteger().toByteArray(), this.ra.getYCoord().toBigInteger().toByteArray(), RB.getXCoord().toBigInteger().toByteArray(), RB.getYCoord().toBigInteger().toByteArray()})});
            return new TransportEntity(this.ra.getEncoded(false), sA, this.z, this.keyPair.getPublicKey());
        }

        public void keyExchange_4(TransportEntity entity) {
            byte[] xV = this.v.getXCoord().toBigInteger().toByteArray();
            byte[] yV = this.v.getYCoord().toBigInteger().toByteArray();
            ECPoint RA = curve.decodePoint(entity.r).normalize();
            byte[] s2 = SM2.sm3hash(new byte[][]{{3}, yV, SM2.sm3hash(new byte[][]{xV, entity.z, this.z, RA.getXCoord().toBigInteger().toByteArray(), RA.getYCoord().toBigInteger().toByteArray(), this.ra.getXCoord().toBigInteger().toByteArray(), this.ra.getYCoord().toBigInteger().toByteArray()})});
            if (Arrays.equals(entity.s, s2)) {
                System.out.println("A->B \u5bc6\u94a5\u786e\u8ba4\u6210\u529f");
            } else {
                System.out.println("A->B \u5bc6\u94a5\u786e\u8ba4\u5931\u8d25");
            }
        }
    }

    private static class TransportEntity
    implements Serializable {
        final byte[] r;
        final byte[] s;
        final byte[] z;
        final byte[] k;

        public TransportEntity(byte[] r, byte[] s, byte[] z, ECPoint pKey) {
            this.r = r;
            this.s = s;
            this.z = z;
            this.k = pKey.getEncoded(false);
        }
    }
}

