/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.crypto.sm2;

import com.citahub.cita.crypto.sm2.SM3;
import com.citahub.cita.utils.HexUtil;
import com.citahub.cita.utils.Numeric;
import com.citahub.cita.utils.Strings;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Keys {
    private static final int PUBLIC_KEY_SIZE = 64;
    private static final int ADDRESS_SIZE = 160;
    private static final int ADDRESS_LENGTH_IN_HEX = 40;
    private static final int PUBLIC_KEY_LENGTH_IN_HEX = 128;

    public static String getAddress(ECPoint key) {
        String pubXStr = key.getRawXCoord().toString();
        String pubYStr = key.getRawYCoord().toString();
        if (pubXStr.length() < 64) {
            pubXStr = Strings.zeros((int)(64 - pubXStr.length())) + pubXStr;
        }
        if (pubYStr.length() < 64) {
            pubYStr = Strings.zeros((int)(64 - pubYStr.length())) + pubYStr;
        }
        String publicKey = pubXStr + pubYStr;
        return SM2Keys.getAddress(publicKey);
    }

    public static String getAddress(String publicKey) {
        String publicKeyNoPrefix = Numeric.cleanHexPrefix((String)publicKey);
        if (publicKeyNoPrefix.length() < 128) {
            publicKeyNoPrefix = Strings.zeros((int)(128 - publicKeyNoPrefix.length())) + publicKeyNoPrefix;
        }
        String hash = null;
        try {
            hash = new BigInteger(1, SM3.hash(HexUtil.hexToBytes((String)publicKeyNoPrefix))).toString(16);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hash.substring(hash.length() - 40);
    }
}

