/*
 * Decompiled with CFR 0.152.
 */
package com.citahub.cita.rlp;

import com.citahub.cita.rlp.RlpType;
import java.math.BigInteger;
import java.util.Arrays;

public class RlpString
implements RlpType {
    private static final byte[] EMPTY = new byte[0];
    private final byte[] value;

    private RlpString(byte[] value) {
        this.value = value;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public static RlpString create(byte[] value) {
        return new RlpString(value);
    }

    public static RlpString create(byte value) {
        return new RlpString(new byte[]{value});
    }

    public static RlpString create(BigInteger value) {
        if (value.signum() < 1) {
            return new RlpString(EMPTY);
        }
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            return new RlpString(Arrays.copyOfRange(bytes, 1, bytes.length));
        }
        return new RlpString(bytes);
    }

    public static RlpString create(long value) {
        return RlpString.create(BigInteger.valueOf(value));
    }

    public static RlpString create(String value) {
        return new RlpString(value.getBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RlpString rlpString = (RlpString)o;
        return Arrays.equals(this.value, rlpString.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

