/*
* Copyright (c) 2008-2015 Citrix Systems, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package com.citrix.sdx.nitro.resource.config.br;

import com.citrix.sdx.nitro.resource.base.*;
import com.citrix.sdx.nitro.datatypes.*;
import com.citrix.sdx.nitro.service.nitro_service;
import com.citrix.sdx.nitro.service.options;
import com.citrix.sdx.nitro.exception.nitro_exception;
import com.citrix.sdx.nitro.util.filtervalue;

class br_replicateconfig_response extends base_response
{
	public br_replicateconfig[] br_replicateconfig;
}

class br_replicateconfig_responses extends base_response
{
	public br_replicateconfig_response[] br_replicateconfig_response_array;
}

/**
 * Configuration for Repeater Replicate Configuration resource
 */

public class br_replicateconfig extends base_resource
{
	private String[] target_ip_address_arr;
	private String source_ip_address;
	private Long __count;

	protected String get_object_type()
	{
		return "br_replicateconfig";
	}

	/**
	 * Returns the value of object identifier argument.
	 */
	protected String get_object_id()
	{
		return source_ip_address;
	}

	/**
	 * <pre>
	 * Target Repeater IP Address Array
	 * </pre>
	 */
	public void set_target_ip_address_arr(String[] target_ip_address_arr)
	{
		this.target_ip_address_arr = target_ip_address_arr;
	}

	/**
	 * <pre>
	 * Target Repeater IP Address Array
	 * </pre>
	 */
	public String[] get_target_ip_address_arr()
	{
		return this.target_ip_address_arr;
	}

	/**
	 * <pre>
	 * Source Repeater IP Address
	 * </pre>
	 */
	public void set_source_ip_address(String source_ip_address)
	{
		this.source_ip_address = source_ip_address;
	}

	/**
	 * <pre>
	 * Source Repeater IP Address
	 * </pre>
	 */
	public String get_source_ip_address()
	{
		return this.source_ip_address;
	}


	/**
	 * <pre>
	 * Use this operation to replicate Repeater config.
	 * </pre>
	 */
	public static br_replicateconfig replicate(nitro_service client, br_replicateconfig resource) throws Exception
	{
		return ((br_replicateconfig[]) resource.perform_operation(client, "replicate"))[0];
	}

	/**
	 * <pre>
	 * Use this operation to replicate Repeater config in bulk.
	 * </pre>
	 */
	public static br_replicateconfig[] replicate(nitro_service client, br_replicateconfig[] resources) throws Exception
	{
		if(resources == null)
			throw new Exception("Null resource array");
		
		
		if(resources.length == 1)
			return ((br_replicateconfig[]) resources[0].perform_operation(client, "replicate"));
		
		return ((br_replicateconfig[]) perform_operation_bulk_request(client, resources, "replicate"));
	}

	/**
	 * <pre>
	 * Converts API response into object and returns the object array in case of get request.
	 * </pre>
	 */
	protected base_resource[] get_nitro_response(nitro_service service, String response) throws Exception
	{
		br_replicateconfig_response result = (br_replicateconfig_response) service.get_payload_formatter().string_to_resource(br_replicateconfig_response.class, response);
		if(result.errorcode != 0)
		{
			if (result.errorcode == SESSION_NOT_EXISTS)
				service.clear_session();
			if(result.severity != null)
			{
				if(result.severity.equals("ERROR"))
					throw new nitro_exception(result.message, result.errorcode);
			}
			else
			{
				throw new nitro_exception(result.message, result.errorcode);
			}
		}
		return result.br_replicateconfig;
	}

	/**
	 * <pre>
	 * Converts API response of bulk operation into object and returns the object array in case of get request.
	 * </pre>
	 */
	protected base_resource[] get_nitro_bulk_response(nitro_service service, String response) throws Exception
	{
		br_replicateconfig_responses result = (br_replicateconfig_responses) service.get_payload_formatter().string_to_resource(br_replicateconfig_responses.class, response);
		if(result.errorcode != 0)
		{
			if (result.errorcode == SESSION_NOT_EXISTS)
				service.clear_session();
			throw new nitro_exception(result.message, result.errorcode, (base_response [])result.br_replicateconfig_response_array);
		}
		br_replicateconfig[] result_br_replicateconfig = new br_replicateconfig[result.br_replicateconfig_response_array.length];
		
		for(int i = 0; i < result.br_replicateconfig_response_array.length; i++)
		{
			result_br_replicateconfig[i] = result.br_replicateconfig_response_array[i].br_replicateconfig[0];
		}
		
		return result_br_replicateconfig;
	}

	/**
	 * <pre>
	 * Performs generic data validation for the operation to be performed
	 * </pre>
	 */
	protected void validate(String operationType) throws Exception
	{
		super.validate(operationType);

		MPSIPAddress source_ip_address_validator = new MPSIPAddress();
		source_ip_address_validator.validate(operationType, source_ip_address, "\"source_ip_address\"");
		
		MPSIPAddress target_ip_address_arr_validator = new MPSIPAddress();
		if(target_ip_address_arr != null)
		{
			for(int i=0; i<target_ip_address_arr.length; i++)
			{
				target_ip_address_arr_validator.validate(operationType, target_ip_address_arr[i], "target_ip_address_arr["+i+"]");
			}
		}
		
	}
}
