/*
 * Decompiled with CFR 0.152.
 */
package com.cj.jshintmojo.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;

public class OptionsParser {
    private static final Pattern GLOBALS_PATTERN = Pattern.compile("\"globals\"\\s*:\\s*\\{(.*?)}", 32);

    private static String removeComments(String withComments) {
        String withoutBlockComments = withComments.replaceAll("\\/\\*(?:(?!\\*\\/)[\\s\\S])*\\*\\/", "");
        String withoutAllComments = withoutBlockComments.replaceAll("\\/\\/[^\\n\\r]*", "");
        return withoutAllComments;
    }

    private static String insideCurly(String jsonString) {
        jsonString = jsonString.trim();
        return jsonString.substring(1, jsonString.length() - 1);
    }

    public static Set<String> extractOptions(byte[] configFileContentsBytes) {
        String configFileContents = new String(configFileContentsBytes);
        String withoutComments = OptionsParser.removeComments(configFileContents);
        Matcher matcher = GLOBALS_PATTERN.matcher(withoutComments);
        String optionsCsv = matcher.replaceAll("").replaceAll("\"", "").replaceAll("\\s", "");
        String optionsBody = OptionsParser.insideCurly(optionsCsv);
        HashSet<String> options = new HashSet<String>();
        for (String option : optionsBody.split(",")) {
            if (StringUtils.isBlank((String)option)) continue;
            options.add(option);
        }
        return options;
    }

    public static Set<String> extractGlobals(byte[] configFileContents) {
        String withoutComments = OptionsParser.removeComments(new String(configFileContents));
        Matcher matcher = GLOBALS_PATTERN.matcher(withoutComments);
        matcher.find();
        String globalsCsv = matcher.group(1).replaceAll("\\s", "").replaceAll("\"", "");
        HashSet<String> globalsSet = new HashSet<String>();
        for (String global : globalsCsv.split(",")) {
            globalsSet.add(global);
        }
        return globalsSet;
    }
}

