/*
 * Decompiled with CFR 0.152.
 */
package com.cj.jshintmojo.reporter;

import com.cj.jshintmojo.cache.Result;
import com.cj.jshintmojo.jshint.JSHint;
import com.cj.jshintmojo.reporter.JSHintReporter;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CheckStyleReporter
implements JSHintReporter {
    public static final String FORMAT = "checkstyle";

    @Override
    public String report(Map<String, Result> results) {
        if (results == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        buf.append("<checkstyle version=\"4.3\">\n");
        Set<String> fileNames = results.keySet();
        Object[] files = fileNames.toArray(new String[fileNames.size()]);
        Arrays.sort(files);
        for (Object file : files) {
            Result result = results.get(file);
            buf.append("\t<file name=\"").append(result.path).append("\">\n");
            for (JSHint.Error error : result.errors) {
                buf.append(String.format("\t\t<error line=\"%d\" column=\"%d\" message=\"%s\" source=\"jshint.%s\" severity=\"%s\" />\n", error.line.intValue(), error.character.intValue(), this.encode(error.reason), this.encode(error.code), this.severity(error.code)));
            }
            buf.append("\t</file>\n");
        }
        buf.append("</checkstyle>\n");
        return buf.toString();
    }

    private String severity(String errorCode) {
        if (StringUtils.isNotEmpty((String)errorCode)) {
            switch (errorCode.charAt(0)) {
                case 'E': {
                    return "error";
                }
                case 'I': {
                    return "info";
                }
            }
        }
        return "warning";
    }

    private String encode(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

