/*
 * Decompiled with CFR 0.152.
 */
package com.cj.jshintmojo.reporter;

import com.cj.jshintmojo.cache.Result;
import com.cj.jshintmojo.jshint.JSHint;
import com.cj.jshintmojo.reporter.JSHintReporter;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class JSLintReporter
implements JSHintReporter {
    public static final String FORMAT = "jslint";

    @Override
    public String report(Map<String, Result> results) {
        if (results == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        buf.append("<jslint>\n");
        Set<String> strings = results.keySet();
        Object[] files = strings.toArray(new String[strings.size()]);
        Arrays.sort(files);
        for (Object file : files) {
            Result result = results.get(file);
            buf.append("\t<file name=\"").append(result.path).append("\">\n");
            for (JSHint.Error issue : result.errors) {
                buf.append(String.format("\t\t<issue line=\"%d\" char=\"%d\" reason=\"%s\" evidence=\"%s\" ", issue.line.intValue(), issue.character.intValue(), this.encode(issue.reason), this.encode(issue.evidence)));
                if (StringUtils.isNotEmpty((String)issue.code)) {
                    buf.append("severity=\"").append(issue.code.charAt(0)).append("\" ");
                }
                buf.append("/>\n");
            }
            buf.append("\t</file>\n");
        }
        buf.append("</jslint>\n");
        return buf.toString();
    }

    private String encode(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

