/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import com.clarifai.api.BaseResponse;
import com.clarifai.api.ClarifaiRequest;
import com.clarifai.api.ConnectionFactory;
import com.clarifai.api.CredentialManager;
import com.clarifai.api.RecognitionResult;
import com.clarifai.api.ResponseUtil;
import com.clarifai.api.exception.ClarifaiBadRequestException;
import com.clarifai.api.exception.ClarifaiException;
import com.clarifai.api.exception.ClarifaiNotAuthorizedException;
import com.clarifai.api.exception.ClarifaiThrottledException;
import com.google.gson.JsonParseException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClarifaiRequester<T> {
    private final ConnectionFactory connectionFactory;
    private final CredentialManager credentialManager;
    private final Method method;
    private final String path;
    private final Class<T> resultClass;
    private final int maxAttempts;

    ClarifaiRequester(ConnectionFactory connectionFactory, CredentialManager credentialManager, Method method, String path, Class<T> resultClass, int maxAttempts) {
        this.connectionFactory = connectionFactory;
        this.credentialManager = credentialManager;
        this.method = method;
        this.path = path;
        this.resultClass = resultClass;
        this.maxAttempts = maxAttempts;
    }

    T execute(ClarifaiRequest request) throws ClarifaiException {
        for (int i = this.maxAttempts - 1; i >= 0; --i) {
            try {
                return this.executeOnce(request);
            }
            catch (ClarifaiNotAuthorizedException e) {
                this.credentialManager.invalidateCredential();
                if (i != 0) continue;
                throw e;
            }
            catch (ClarifaiThrottledException e) {
                if (i == 0) {
                    throw e;
                }
                ClarifaiRequester.waitForSeconds(e.getWaitSeconds());
                continue;
            }
            catch (ClarifaiBadRequestException e) {
                throw e;
            }
            catch (ClarifaiException e) {
                if (i != 0) continue;
                throw e;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T executeOnce(ClarifaiRequest request) throws ClarifaiException {
        try {
            BaseResponse response;
            boolean isSuccess;
            HttpURLConnection conn = this.method == Method.POST ? this.connectionFactory.newPost(this.path, this.credentialManager.getCredential()) : this.connectionFactory.newGet(this.path, this.credentialManager.getCredential());
            if (request != null) {
                conn.setRequestProperty("Content-Type", request.getContentType());
                BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
                try {
                    request.writeContent(out);
                }
                finally {
                    out.close();
                }
            }
            boolean bl = isSuccess = conn.getResponseCode() >= 200 && conn.getResponseCode() < 300;
            if (isSuccess) {
                response = ResponseUtil.parseJsonAndClose(conn.getInputStream(), BaseResponse.class);
            } else {
                response = ResponseUtil.parseJsonAndClose(conn.getErrorStream(), BaseResponse.class);
                if (conn.getResponseCode() == 400 && this.resultClass == RecognitionResult[].class && response.results != null && response.results.isJsonArray()) {
                    isSuccess = true;
                } else {
                    ResponseUtil.throwExceptionForErrorResponse(conn, response);
                }
            }
            if (this.resultClass == Void.class) {
                return null;
            }
            return (T)ResponseUtil.GSON.fromJson(response.results, this.resultClass);
        }
        catch (IOException e) {
            throw new ClarifaiException("IOException", e);
        }
        catch (JsonParseException e) {
            throw new ClarifaiException("Server returned an unparsable response", e);
        }
    }

    private static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClarifaiException("Interrupted", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Method {
        GET,
        POST;

    }
}

