/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Random;

class Multipart {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int BUFFER_SIZE = 4096;
    private OutputStream out;
    private final String boundary = Long.toHexString(new Random().nextLong());

    public String getBoundary() {
        return this.boundary;
    }

    public void start(OutputStream out) {
        this.out = out;
    }

    public void finish() throws IOException {
        this.out.write(("--" + this.boundary + "--\r\n").getBytes(UTF8));
        this.out.flush();
    }

    public void writeParameter(String name, String value) throws IOException {
        this.writeBoundary();
        String payload = "Content-Disposition: form-data; name=\"" + name + "\"\r\n\r\n" + value + "\r\n";
        this.out.write(payload.getBytes(UTF8));
    }

    public void writeMedia(String name, String filename, InputStream in) throws IOException {
        int numRead;
        this.writeBoundary();
        String header = "Content-Disposition: form-data; name=\"" + name + "\";" + " filename=\"" + filename + "\"\r\n" + "Content-Type: application/octet-stream\r\n\r\n";
        this.out.write(header.getBytes(UTF8));
        byte[] buf = new byte[4096];
        while ((numRead = in.read(buf)) >= 0) {
            this.out.write(buf, 0, numRead);
        }
        this.out.write("\r\n".getBytes(UTF8));
    }

    private void writeBoundary() throws IOException {
        this.out.write(("--" + this.boundary + "\r\n").getBytes(UTF8));
    }
}

