/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import com.clarifai.api.ResponseUtil;
import com.clarifai.api.Tag;
import com.clarifai.api.VideoSegment;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecognitionResult {
    private final StatusCode statusCode;
    private String statusMessage;
    private final String docId;
    private List<Tag> tags;
    private double[] embedding;
    private List<VideoSegment> videoSegments;
    private final JsonObject jsonResponse;

    private static boolean isVideoResult(JsonObject result) {
        JsonArray embedArray;
        JsonElement timestamps;
        if (result.get("tag") != null && result.get("tag").isJsonObject() && (timestamps = result.get("tag").getAsJsonObject().get("timestamps")) != null && timestamps.isJsonArray()) {
            return true;
        }
        return result.get("embed") != null && result.get("embed").isJsonArray() && (embedArray = result.get("embed").getAsJsonArray()).size() > 0 && embedArray.get(0).isJsonArray();
    }

    private static List<Tag> tagsForClassesAndProbs(String[] classes, double[] probs) {
        int count = Math.min(classes.length, probs.length);
        ArrayList<Tag> tags = new ArrayList<Tag>(count);
        for (int i = 0; i < count; ++i) {
            tags.add(new Tag(classes[i], probs[i]));
        }
        return tags;
    }

    private RecognitionResult(MediaResultEnvelope envelope, List<Tag> tags, double[] embedding, List<VideoSegment> videoSegments, String errorMessage) {
        this.statusCode = "OK".equals(envelope.statusCode) ? StatusCode.OK : ("CLIENT_ERROR".equals(envelope.statusCode) ? StatusCode.CLIENT_ERROR : StatusCode.SERVER_ERROR);
        this.statusMessage = envelope.statusMsg;
        this.docId = envelope.docidStr;
        this.jsonResponse = envelope.result;
        this.videoSegments = videoSegments;
        if (videoSegments != null && videoSegments.size() > 0) {
            this.tags = videoSegments.get(0).getTags();
            this.embedding = videoSegments.get(0).getEmbedding();
        } else {
            this.tags = tags;
            this.embedding = embedding;
        }
        if (errorMessage != null) {
            this.statusMessage = this.statusMessage + " " + errorMessage;
        }
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getDocId() {
        return this.docId;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public double[] getEmbedding() {
        return this.embedding;
    }

    public List<VideoSegment> getVideoSegments() {
        return this.videoSegments;
    }

    public JsonObject getJsonResponse() {
        return this.jsonResponse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusCode {
        OK,
        CLIENT_ERROR,
        SERVER_ERROR;

    }

    static class ErrorResultMessage {
        private String error;

        ErrorResultMessage() {
        }
    }

    static class VideoTagMessage {
        private double[] timestamps;
        private String[][] classes;
        private double[][] probs;

        VideoTagMessage() {
        }
    }

    static class VideoResultMessage {
        private VideoTagMessage tag;
        private double[][] embed;

        VideoResultMessage() {
        }
    }

    static class ImageTagMessage {
        private String[] classes;
        private double[] probs;

        ImageTagMessage() {
        }
    }

    static class ImageResultMessage {
        private ImageTagMessage tag;
        private double[] embed;

        ImageResultMessage() {
        }
    }

    static class MediaResultEnvelope {
        private String statusCode;
        private String statusMsg;
        private String docidStr;
        private JsonObject result;

        MediaResultEnvelope() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Deserializer
    implements JsonDeserializer<RecognitionResult> {
        Deserializer() {
        }

        public RecognitionResult deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            MediaResultEnvelope envelope = (MediaResultEnvelope)ResponseUtil.GSON.fromJson(json, MediaResultEnvelope.class);
            if (RecognitionResult.isVideoResult(envelope.result)) {
                VideoResultMessage result = (VideoResultMessage)ResponseUtil.GSON.fromJson((JsonElement)envelope.result, VideoResultMessage.class);
                ArrayList<VideoSegment> segments = new ArrayList<VideoSegment>();
                if (result.tag != null) {
                    int numTags = Math.min(Math.min(result.tag.timestamps.length, result.tag.classes.length), result.tag.probs.length);
                    for (int i = 0; i < numTags; ++i) {
                        double timestamp = result.tag.timestamps[i];
                        List tags = RecognitionResult.tagsForClassesAndProbs(result.tag.classes[i], result.tag.probs[i]);
                        double[] embed = result.embed != null && result.embed.length > i ? result.embed[i] : null;
                        segments.add(new VideoSegment(timestamp, tags, embed));
                    }
                } else if (result.embed != null) {
                    for (int i = 0; i < result.embed.length; ++i) {
                        segments.add(new VideoSegment(i, null, result.embed[i]));
                    }
                }
                return new RecognitionResult(envelope, null, null, segments, null);
            }
            if (envelope.result.get("tag") != null || envelope.result.get("embed") != null) {
                ImageResultMessage result = (ImageResultMessage)ResponseUtil.GSON.fromJson((JsonElement)envelope.result, ImageResultMessage.class);
                List tags = null;
                if (result.tag != null) {
                    tags = RecognitionResult.tagsForClassesAndProbs(result.tag.classes, result.tag.probs);
                }
                return new RecognitionResult(envelope, tags, result.embed, null, null);
            }
            ErrorResultMessage result = (ErrorResultMessage)ResponseUtil.GSON.fromJson((JsonElement)envelope.result, ErrorResultMessage.class);
            return new RecognitionResult(envelope, null, null, null, result.error);
        }
    }
}

