/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.channel;

import com.clarifai.channel.JsonChannel;
import com.clarifai.channel.JsonMarshaller;
import com.clarifai.channel.http.ClarifaiHttpClient;
import com.google.protobuf.Message;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.protobuf.ProtoUtils;
import javax.net.ssl.SSLException;

public enum ClarifaiChannel {
    INSTANCE;

    public static final int MAX_MESSAGE_LENGTH = 0x8000000;
    private MarshallerType marshallerType = MarshallerType.PROTO;

    public ManagedChannel getGrpcChannel() {
        String base = System.getenv("CLARIFAI_GRPC_BASE");
        if (base == null) {
            base = "api.clarifai.com";
        }
        return this.getGrpcChannel(base);
    }

    public ManagedChannel getGrpcChannel(String base) {
        try {
            this.marshallerType = MarshallerType.PROTO;
            return NettyChannelBuilder.forAddress((String)base, (int)443).maxInboundMessageSize(0x8000000).sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build()).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    public ManagedChannel getInsecureGrpcChannel() {
        this.marshallerType = MarshallerType.PROTO;
        return NettyChannelBuilder.forAddress((String)"api-grpc.clarifai.com", (int)18080).usePlaintext().maxInboundMessageSize(0x8000000).build();
    }

    public JsonChannel getJsonChannel() {
        return this.getJsonChannel(new ClarifaiHttpClient.Default());
    }

    public JsonChannel getJsonChannel(ClarifaiHttpClient clarifaiHttpClient) {
        this.marshallerType = MarshallerType.JSON;
        return new JsonChannel(clarifaiHttpClient);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        switch (ClarifaiChannel.INSTANCE.marshallerType) {
            case PROTO: {
                return ProtoUtils.marshaller(defaultInstance);
            }
            case JSON: {
                return JsonMarshaller.jsonMarshaller(defaultInstance);
            }
        }
        throw new RuntimeException("Unhandled marshaller type " + (Object)((Object)ClarifaiChannel.INSTANCE.marshallerType));
    }

    private static enum MarshallerType {
        PROTO,
        JSON;

    }
}

