/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.channel;

import com.clarifai.grpc.api.Concept;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;

public final class JsonMarshaller {
    private JsonMarshaller() {
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> jsonMarshaller(T defaultInstance) {
        JsonFormat.Parser parser = JsonFormat.parser().ignoringUnknownFields();
        Descriptors.FieldDescriptor value = Concept.newBuilder().getDescriptorForType().findFieldByName("value");
        HashSet<Descriptors.FieldDescriptor> defaultValueFields = new HashSet<Descriptors.FieldDescriptor>();
        defaultValueFields.add(value);
        JsonFormat.Printer printer = JsonFormat.printer().preservingProtoFieldNames().includingDefaultValueFields(defaultValueFields);
        return JsonMarshaller.jsonMarshaller(defaultInstance, parser, printer);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> jsonMarshaller(final T defaultInstance, final JsonFormat.Parser parser, final JsonFormat.Printer printer) {
        final Charset charset = Charset.forName("UTF-8");
        return new MethodDescriptor.Marshaller<T>(){

            public InputStream stream(T value) {
                try {
                    return new ByteArrayInputStream(printer.print(value).getBytes(charset));
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withCause((Throwable)e).withDescription("Unable to print json proto").asRuntimeException();
                }
            }

            public T parse(InputStream stream) {
                Message proto;
                Message.Builder builder = defaultInstance.newBuilderForType();
                InputStreamReader reader = new InputStreamReader(stream, charset);
                try {
                    parser.merge((Reader)reader, builder);
                    proto = builder.build();
                    ((Reader)reader).close();
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
                }
                catch (IOException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
                }
                return proto;
            }
        };
    }
}

