/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.channel;

import com.clarifai.channel.JsonEndpoint;
import com.clarifai.channel.http.ClarifaiHttpClient;
import com.clarifai.credentials.ClarifaiCallCredentials;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import javax.annotation.Nullable;

public class JsonChannel
extends Channel {
    private final ClarifaiHttpClient clarifaiHttpClient;

    JsonChannel(ClarifaiHttpClient clarifaiHttpClient) {
        this.clarifaiHttpClient = clarifaiHttpClient;
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        ClarifaiCallCredentials credentials = (ClarifaiCallCredentials)callOptions.getCredentials();
        return new JsonClientCall<RequestT, ResponseT>(this.clarifaiHttpClient, methodDescriptor, credentials.getApiKey());
    }

    public String authority() {
        return null;
    }

    private class JsonClientCall<RequestT, ResponseT>
    extends ClientCall<RequestT, ResponseT> {
        private final ClarifaiHttpClient clarifaiHttpClient;
        private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
        private final String apiKey;
        private ClientCall.Listener<ResponseT> responseListener;

        JsonClientCall(ClarifaiHttpClient clarifaiHttpClient, MethodDescriptor<RequestT, ResponseT> methodDescriptor, String apiKey) {
            this.clarifaiHttpClient = clarifaiHttpClient;
            this.methodDescriptor = methodDescriptor;
            this.apiKey = apiKey;
        }

        public void start(ClientCall.Listener<ResponseT> responseListener, Metadata headers) {
            responseListener.onReady();
            this.responseListener = responseListener;
        }

        public void request(int numMessages) {
        }

        public void cancel(@Nullable String message, @Nullable Throwable cause) {
        }

        public void halfClose() {
        }

        public void sendMessage(Object message) {
            InputStream stream = this.methodDescriptor.getRequestMarshaller().stream(message);
            String fullRequestString = this.streamToString(stream);
            JsonObject request = (JsonObject)new Gson().fromJson(fullRequestString, JsonObject.class);
            JsonEndpoint.Endpoint endpoint = new JsonEndpoint<RequestT, ResponseT>(this.methodDescriptor, request).pickProperEndpoint();
            for (String urlField : endpoint.getUrlFields()) {
                request.remove(urlField);
            }
            String responseString = this.clarifaiHttpClient.executeRequest(this.apiKey, endpoint.getUrl(), endpoint.getMethod(), request);
            Object responseObject = this.methodDescriptor.getResponseMarshaller().parse((InputStream)new ByteArrayInputStream(responseString.getBytes(StandardCharsets.UTF_8)));
            this.responseListener.onMessage(responseObject);
            this.responseListener.onClose(Status.OK, new Metadata());
        }

        private String streamToString(InputStream stream) {
            Scanner s = new Scanner(stream, "utf-8").useDelimiter("\\A");
            String requestString = s.hasNext() ? s.next() : "";
            s.close();
            return requestString;
        }
    }
}

