/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.channel;

import com.clarifai.channel.ClarifaiException;
import com.google.api.HttpRule;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.Descriptors;
import io.grpc.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JsonEndpoint<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final JsonObject request;
    private final HashMap<String, JsonElement> requestMap = new HashMap();
    private static final Pattern URL_FIELDS_PATTERN = Pattern.compile("\\{(.*?)\\}");

    JsonEndpoint(MethodDescriptor<RequestT, ResponseT> methodDescriptor, JsonObject request) {
        this.methodDescriptor = methodDescriptor;
        this.request = request;
        for (Map.Entry entry : request.entrySet()) {
            this.requestMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    Endpoint pickProperEndpoint() {
        Descriptors.MethodDescriptor schemaMethodDescriptor;
        Method m;
        Object schemaDescriptor = this.methodDescriptor.getSchemaDescriptor();
        try {
            m = schemaDescriptor.getClass().getMethod("getMethodDescriptor", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        m.setAccessible(true);
        try {
            schemaMethodDescriptor = (Descriptors.MethodDescriptor)m.invoke(schemaDescriptor, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        Set allFields = schemaMethodDescriptor.getOptions().getAllFields().entrySet();
        for (Map.Entry pair : allFields) {
            String userId;
            String appId;
            if (pair.getValue().getClass() != HttpRule.class) continue;
            final HttpRule rule = (HttpRule)pair.getValue();
            String bestMatchUrl = null;
            String bestMatchMethod = null;
            ArrayList<String> bestMatchUrlFields = null;
            int bestMatchCount = -1;
            String[] ids = this.readAppIdAndUserId((JsonElement)this.request);
            if (ids.length == 2) {
                appId = ids[0];
                userId = ids[1];
            } else {
                appId = null;
                userId = null;
            }
            ArrayList<HttpRule> allRules = new ArrayList<HttpRule>(){
                {
                    this.add(rule);
                    this.addAll(rule.getAdditionalBindingsList());
                }
            };
            for (HttpRule httpRule : allRules) {
                String method = httpRule.getPatternCase().name();
                String urlTemplate = this.url(httpRule, method);
                Matcher matcher = URL_FIELDS_PATTERN.matcher(urlTemplate);
                boolean allArgumentsTranslated = true;
                int count = 0;
                String url = urlTemplate;
                ArrayList<String> urlFields = new ArrayList<String>();
                while (matcher.find()) {
                    String value;
                    String field = matcher.group(1);
                    String[] parts = field.split("\\.");
                    String fieldName = parts[parts.length - 1];
                    if (fieldName.equals("app_id")) {
                        if (appId == null) {
                            allArgumentsTranslated = false;
                            break;
                        }
                        value = appId;
                    } else if (fieldName.equals("user_id")) {
                        value = userId != null ? userId : "me";
                    } else {
                        if (!this.requestMap.containsKey(fieldName)) {
                            allArgumentsTranslated = false;
                            break;
                        }
                        value = this.requestMap.get(fieldName).getAsString();
                    }
                    url = url.replace("{" + field + "}", value);
                    urlFields.add(field);
                    ++count;
                }
                if (!allArgumentsTranslated || bestMatchCount >= count) continue;
                bestMatchUrl = url;
                bestMatchMethod = method;
                bestMatchCount = count;
                bestMatchUrlFields = urlFields;
            }
            if (bestMatchUrl == null) continue;
            return new Endpoint(bestMatchMethod, bestMatchUrl, bestMatchUrlFields);
        }
        throw new RuntimeException("Unable to find an appropriate HTTP endpoint");
    }

    private String[] readAppIdAndUserId(JsonElement element) {
        block7: {
            block6: {
                if (!element.isJsonArray()) break block6;
                for (JsonElement e : element.getAsJsonArray()) {
                    String[] vals = this.readAppIdAndUserId(e);
                    if (vals.length != 2) continue;
                    return vals;
                }
                break block7;
            }
            if (!element.isJsonObject()) break block7;
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                String[] vals;
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (key.equals("user_app_id")) {
                    String[] result = new String[2];
                    JsonObject userAppId = value.getAsJsonObject();
                    result[0] = userAppId.get("app_id").getAsString();
                    result[1] = userAppId.has("user_id") ? userAppId.get("user_id").getAsString() : "me";
                    return result;
                }
                if (key.equals("apps")) {
                    JsonArray apps = value.getAsJsonArray();
                    if (apps.size() == 1) {
                        String[] result = new String[2];
                        JsonObject app = apps.get(0).getAsJsonObject();
                        result[0] = app.get("id").getAsString();
                        result[1] = app.has("user_id") ? app.get("user_id").getAsString() : "me";
                        return result;
                    }
                    if (apps.size() == 0) {
                        return new String[0];
                    }
                    throw new ClarifaiException("Only one app is supported at this time.");
                }
                if (key.equals("metadata") || (vals = this.readAppIdAndUserId(value)).length != 2) continue;
                return vals;
            }
        }
        return new String[0];
    }

    private String url(HttpRule httpRule, String method) {
        String urlTemplate;
        switch (method) {
            case "GET": {
                urlTemplate = httpRule.getGet();
                break;
            }
            case "POST": {
                urlTemplate = httpRule.getPost();
                break;
            }
            case "PATCH": {
                urlTemplate = httpRule.getPatch();
                break;
            }
            case "DELETE": {
                urlTemplate = httpRule.getDelete();
                break;
            }
            default: {
                throw new ClarifaiException("Unhandled method " + method);
            }
        }
        return urlTemplate;
    }

    class Endpoint {
        private final String method;
        private final String url;
        private final ArrayList<String> urlFields;

        Endpoint(String method, String url, ArrayList<String> urlFields) {
            this.method = method;
            this.url = url;
            this.urlFields = urlFields;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public ArrayList<String> getUrlFields() {
            return this.urlFields;
        }
    }
}

